/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils.math.parser;

import io.github.flemmli97.tenshilib.common.utils.math.parser.ExpValue;
import io.github.flemmli97.tenshilib.common.utils.math.parser.FunctionRegistry;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.BuiltinValues;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.Operators;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.logic.Condition;
import java.util.Random;
import java.util.Stack;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.TestOnly;

public class Expression {
    private static final String NUMBER = "\\d+(?:\\.\\d+)?";
    private static final String VARIABLE = "(?<!\\.)[A-Za-z][A-Za-z._]*";
    private static final String OPERATOR = Operators.regex() + "|(?:[?:])|[()]";
    private static final Pattern PATTERN = Pattern.compile(String.format("(?:%1$s)|(?:%2$s)|%3$s|,", "\\d+(?:\\.\\d+)?", "(?<!\\.)[A-Za-z][A-Za-z._]*", OPERATOR));

    private static String variableEquivalent(String variable) {
        if (variable.equals("anim_time") || variable.equals("time")) {
            variable = "query.anim_time";
        }
        return variable;
    }

    public static ExpValue of(String exp) {
        exp = exp.replace(" ", "").replace("\n", "");
        try {
            double val = Double.parseDouble(exp);
            if (val == 0.0) {
                return ExpValue.DEFAULT;
            }
            return new BuiltinValues.ConstantValue(val);
        }
        catch (NumberFormatException val) {
            Stack<TokenHolder> output = Expression.shuntingYard(exp);
            Stack<ExpValue> vars = new Stack<ExpValue>();
            for (TokenHolder op : output) {
                block1 : switch (op.type.ordinal()) {
                    case 0: {
                        vars.push(new BuiltinValues.ConstantValue(Double.parseDouble(op.token)));
                        break;
                    }
                    case 1: {
                        if (op.token.equals("pi") || op.token.equals("PI")) {
                            vars.push(new BuiltinValues.ConstantValue(Math.PI));
                            break;
                        }
                        vars.push(new BuiltinValues.VariableValue(Expression.variableEquivalent(op.token)));
                        break;
                    }
                    case 2: {
                        switch (op.token) {
                            case "-": {
                                ExpValue value = vars.pop();
                                vars.push(new BuiltinValues.NegativeValue(value));
                                break block1;
                            }
                            case "+": {
                                ExpValue value = vars.pop();
                                vars.push(value);
                                break block1;
                            }
                            case "!": {
                                ExpValue value = vars.pop();
                                vars.push(new BuiltinValues.NegatedValue(value));
                            }
                        }
                        break;
                    }
                    case 3: {
                        Operators.get(op.token, vars);
                        break;
                    }
                    case 5: {
                        ExpValue otherwise = (ExpValue)vars.pop();
                        ExpValue then = vars.pop();
                        ExpValue condition = vars.pop();
                        vars.push(new Condition(condition, then, otherwise));
                        break;
                    }
                    case 6: {
                        ExpValue value = FunctionRegistry.tryConstruct(op.token, vars);
                        if (value == null) break;
                        vars.push(value);
                    }
                }
            }
            if (vars.size() > 1) {
                throw new IllegalStateException("Not all tokens processed! Unable to parse expression " + exp + " - Leftover Tokens: " + String.valueOf(vars));
            }
            return (ExpValue)vars.pop();
        }
    }

    private static Stack<TokenHolder> shuntingYard(String exp) {
        Stack<TokenHolder> output = new Stack<TokenHolder>();
        Stack<TokenHolder> operators = new Stack<TokenHolder>();
        Matcher matcher = PATTERN.matcher(exp);
        TokenHolder lastType = null;
        while (matcher.find()) {
            String token = Expression.stripPrefix(matcher.group());
            TokenHolder holder = TokenHolder.of(token, lastType);
            if (lastType != null && lastType.type() == Type.VAR && holder.type() == Type.BRACKETOPEN) {
                throw new IllegalStateException("Unknown function '" + ((TokenHolder)output.getLast()).token + "'");
            }
            switch (holder.type().ordinal()) {
                case 0: 
                case 1: {
                    output.add(holder);
                    break;
                }
                case 6: 
                case 7: {
                    operators.add(holder);
                    break;
                }
                case 9: {
                    while (!operators.empty() && ((TokenHolder)operators.peek()).type != Type.BRACKETOPEN) {
                        output.add((TokenHolder)operators.pop());
                    }
                    break;
                }
                case 8: {
                    while (!operators.empty() && ((TokenHolder)operators.peek()).type != Type.BRACKETOPEN) {
                        output.add((TokenHolder)operators.pop());
                    }
                    if (operators.empty()) {
                        throw new IllegalStateException("Mismatched brackets!");
                    }
                    operators.pop();
                    if (((TokenHolder)operators.peek()).type != Type.FUNC) break;
                    output.add((TokenHolder)operators.pop());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    while (!operators.empty()) {
                        TokenHolder op = (TokenHolder)operators.peek();
                        if (!op.type.isOp() || holder.precedence() >= op.precedence() && (holder.precedence() != op.precedence() || !holder.leftAssociative())) break;
                        output.add((TokenHolder)operators.pop());
                    }
                    operators.add(holder);
                }
            }
            lastType = holder;
        }
        while (!operators.empty()) {
            TokenHolder op = (TokenHolder)operators.pop();
            if (op.type == Type.BRACKETOPEN || op.type == Type.BRACKETCLOSE) {
                throw new IllegalStateException("Mismatched brackets!");
            }
            output.push(op);
        }
        return output;
    }

    private static String stripPrefix(String token) {
        if (token.startsWith("math.")) {
            return token.replaceFirst("math.", "");
        }
        return token;
    }

    @TestOnly
    public static void test() {
        Expression.verify("1+2+3+4", new VariableMap(), 0, 10.0);
        Expression.verify("-1+2+-3+4", new VariableMap(), 0, 2.0);
        Expression.verify("2*4+7", new VariableMap(), 0, 15.0);
        Expression.verify("2*-4+7+3", new VariableMap(), 0, 2.0);
        Expression.verify("5+7+3+1*6*3+9", new VariableMap(), 0, 42.0);
        Expression.verify("5+(44+1)*4*1/6+99", new VariableMap(), 0, 134.0);
        Expression.verify("-5+5+(-3*5)", new VariableMap(), 0, -15.0);
        Expression.verify("math.sin(time*(44+1)+3)*4*1/6", new VariableMap().setVariable("query.anim_time", 5.0), 5, -0.49543);
        Expression.verify("99*math.cos(1)", new VariableMap(), 5, 98.98492);
        Expression.verify("-math.sin(time*180)+17.5", new VariableMap().setVariable("query.anim_time", 0.0), 0, 17.5);
        Expression.verify("1 + math.sin(time*180)-17.5", new VariableMap().setVariable("query.anim_time", 0.0), 0, -16.5);
        Expression.verify("math.sin(query.anim_time * 1200) * 6 * query.above_top_solid", new VariableMap().setVariable("query.anim_time", 4.0).setVariable("query.above_top_solid", 9.0), 3, 46.765);
        Expression.verify("ln(5) * sqrt(16) * 3^6 * pi", new VariableMap(), 3, 14743.874);
        Expression.verify("5 % 3", new VariableMap(), 0, 2.0);
        Expression.verify("5 % 7", new VariableMap(), 0, 5.0);
        Expression.verify("2^2^2", new VariableMap(), 0, 16.0);
        ExpValue exp10 = Expression.of("random(3,8)");
        System.out.println("Expression 10: " + String.valueOf(exp10) + " res " + exp10.get(new VariableMap()));
        ExpValue exp11 = Expression.of("random_integer(3,8)");
        System.out.println("Expression 11: " + String.valueOf(exp11) + " res " + exp11.get(new VariableMap()));
        Expression.verify("5 == 5", new VariableMap(), 0, 1.0);
        Expression.verify("5 == 6", new VariableMap(), 0, 0.0);
        Expression.verify("5 != 6", new VariableMap(), 0, 1.0);
        Expression.verifyBool("<", new VariableMap(), 1000, 20, (f, s) -> f < s);
        Expression.verifyBool("<=", new VariableMap(), 10, 40, (f, s) -> f <= s);
        Expression.verifyBool(">", new VariableMap(), 1000, 20, (f, s) -> f > s);
        Expression.verifyBool(">=", new VariableMap(), 10, 40, (f, s) -> f >= s);
        Expression.verify("5 == 6 || 5 == 5", new VariableMap(), 0, 1.0);
        Expression.verify("5 == 6 || 5 == 7", new VariableMap(), 0, 0.0);
        Expression.verify("5 == 6 && 5 == 5", new VariableMap(), 0, 0.0);
        Expression.verify("5 == 5 && 3 <= 3", new VariableMap(), 0, 1.0);
        Expression.verify("5 == 5 ? 6 + 3 : 3 + 1", new VariableMap(), 0, 9.0);
        Expression.verify("5 != 5 ? 6 + 3 : 3 ^ 3", new VariableMap(), 0, 27.0);
    }

    private static void verifyBool(String op, VariableMap vars, int bounds, int amount, BiPredicate<Integer, Integer> check) {
        for (int i = 0; i < amount; ++i) {
            int first = new Random().nextInt(bounds);
            int second = new Random().nextInt(bounds);
            System.out.println("Evaluating expression: " + first + op + second);
            ExpValue expression = Expression.of(first + op + second);
            System.out.println("Parsed: " + String.valueOf(expression));
            Expression.verify(expression.get(vars), check.test(first, second) ? 1.0 : 0.0);
        }
    }

    private static void verify(String input, VariableMap vars, int decimals, double truth) {
        System.out.println("Evaluating expression: " + input);
        ExpValue expression = Expression.of(input);
        System.out.println("Parsed: " + String.valueOf(expression));
        if (decimals == 0) {
            Expression.verify(expression.get(vars), truth);
        } else {
            Expression.verify(Expression.roundDecimal(expression.get(vars), decimals), truth);
        }
    }

    private static void verify(double value, double truth) {
        if (value != truth) {
            throw new IllegalStateException(String.format("Wrong min. Expected %s but was %s", truth, value));
        }
    }

    private static double roundDecimal(double value, int decimals) {
        double pow = Math.pow(10.0, decimals);
        return (double)Math.round(value * pow) / pow;
    }

    record TokenHolder(Type type, int precedence, boolean leftAssociative, String token) {
        public TokenHolder(Type type, int precedence, String token) {
            this(type, precedence, true, token);
        }

        public static TokenHolder of(String token, TokenHolder last) {
            TokenHolder tokenHolder;
            if (FunctionRegistry.has(token)) {
                return new TokenHolder(Type.FUNC, 100, token);
            }
            switch (token) {
                case ",": {
                    TokenHolder tokenHolder2;
                    tokenHolder = tokenHolder2 = new TokenHolder(Type.DELIMITER, 0, token);
                    break;
                }
                case "^": {
                    TokenHolder tokenHolder3;
                    tokenHolder = tokenHolder3 = new TokenHolder(Type.BINARY_OP, 12, false, token);
                    break;
                }
                case "*": 
                case "/": 
                case "%": {
                    TokenHolder tokenHolder4;
                    tokenHolder = tokenHolder4 = new TokenHolder(Type.BINARY_OP, 11, token);
                    break;
                }
                case "+": 
                case "-": 
                case "!": {
                    TokenHolder tokenHolder5;
                    if (last == null || last.type().args > 1 || last.type() == Type.BRACKETOPEN || last.type() == Type.DELIMITER) {
                        TokenHolder tokenHolder6;
                        tokenHolder = tokenHolder6 = new TokenHolder(Type.UNARY_OP, 100, false, token);
                        break;
                    }
                    tokenHolder = tokenHolder5 = new TokenHolder(Type.BINARY_OP, 10, token);
                    break;
                }
                case "<": 
                case "<=": 
                case ">": 
                case ">=": {
                    TokenHolder tokenHolder7;
                    tokenHolder = tokenHolder7 = new TokenHolder(Type.BINARY_OP, 9, token);
                    break;
                }
                case "==": 
                case "!=": {
                    TokenHolder tokenHolder8;
                    tokenHolder = tokenHolder8 = new TokenHolder(Type.BINARY_OP, 8, token);
                    break;
                }
                case "&&": {
                    TokenHolder tokenHolder9;
                    tokenHolder = tokenHolder9 = new TokenHolder(Type.BINARY_OP, 7, token);
                    break;
                }
                case "||": {
                    TokenHolder tokenHolder10;
                    tokenHolder = tokenHolder10 = new TokenHolder(Type.BINARY_OP, 6, token);
                    break;
                }
                case "?:": {
                    TokenHolder tokenHolder11;
                    tokenHolder = tokenHolder11 = new TokenHolder(Type.BINARY_OP, 5, token);
                    break;
                }
                case "?": {
                    TokenHolder tokenHolder12;
                    tokenHolder = tokenHolder12 = new TokenHolder(Type.TERNARY_START, 5, token);
                    break;
                }
                case ":": {
                    TokenHolder tokenHolder13;
                    tokenHolder = tokenHolder13 = new TokenHolder(Type.TERNARY_END, 4, token);
                    break;
                }
                case "(": {
                    TokenHolder tokenHolder14;
                    tokenHolder = tokenHolder14 = new TokenHolder(Type.BRACKETOPEN, 0, token);
                    break;
                }
                case ")": {
                    TokenHolder tokenHolder15;
                    tokenHolder = tokenHolder15 = new TokenHolder(Type.BRACKETCLOSE, 0, token);
                    break;
                }
                case "pi": 
                case "PI": {
                    TokenHolder tokenHolder16;
                    tokenHolder = tokenHolder16 = new TokenHolder(Type.VAR, 0, token);
                    break;
                }
                default: {
                    try {
                        TokenHolder tokenHolder17;
                        Double.parseDouble(token);
                        tokenHolder = tokenHolder17 = new TokenHolder(Type.NUMBER, 0, token);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        TokenHolder tokenHolder18;
                        tokenHolder = tokenHolder18 = new TokenHolder(Type.VAR, 0, token);
                    }
                }
            }
            return tokenHolder;
        }
    }

    public static enum Type {
        NUMBER(0),
        VAR(0),
        UNARY_OP(1),
        BINARY_OP(2),
        TERNARY_START(3),
        TERNARY_END(3),
        FUNC(-1),
        BRACKETOPEN(0),
        BRACKETCLOSE(0),
        DELIMITER(0);

        public final int args;

        private Type(int args) {
            this.args = args;
        }

        public boolean isOp() {
            return this == UNARY_OP || this == BINARY_OP || this == TERNARY_START || this == TERNARY_END;
        }
    }
}

