/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui.widget.list;

import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableEntry;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import net.minecraft.class_6880;

public class SelectableListWidget
extends class_339 {
    private final class_327 font;
    private final List<SelectableEntry> entries;
    private final boolean[] selected;
    private int entryHeight;
    private int limit;
    private class_2960 background;
    private int paddingY = 4;
    private Scrollbar scrollbar;
    private boolean canSelectMultiple;
    private int offset;
    private int hovered;
    private int lastSelect;
    private boolean mouseScrollDragging;

    public SelectableListWidget(int x, int y, int width, int height, class_327 font, List<SelectableEntry> entries) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.font = font;
        this.entries = entries;
        this.selected = new boolean[this.entries.size()];
        Objects.requireNonNull(this.font);
        this.setEntryHeight(9 + 3, this.paddingY);
    }

    public SelectableListWidget setEntryHeight(int height, int paddingY) {
        this.entryHeight = height;
        this.entries.forEach(e -> e.updateDimensions(this.getEntryWidth(), this.entryHeight));
        return this.withPadding(paddingY);
    }

    public SelectableListWidget withPadding(int paddingY) {
        this.paddingY = paddingY;
        this.limit = (this.field_22759 + this.paddingY) / (this.entryHeight + this.paddingY);
        return this;
    }

    public SelectableListWidget withTexture(class_2960 background) {
        this.background = background;
        return this;
    }

    public SelectableListWidget selectMultiple() {
        this.canSelectMultiple = true;
        return this;
    }

    public SelectableListWidget scrollbar(Scrollbar scrollbar) {
        this.scrollbar = scrollbar;
        this.entries.forEach(e -> e.updateDimensions(this.getEntryWidth(), this.entryHeight));
        return this;
    }

    protected int getEntryWidth() {
        return this.method_25368() - (this.scrollbar != null ? this.scrollbar.totalWidth() : 0);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.background != null) {
            graphics.method_52706(this.background, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        }
        this.hoverOver(this.field_22762 ? this.indexFromMouse(mouseX, mouseY) : -1);
        for (int i = 0; i < this.entries.size(); ++i) {
            int idxx = (this.offset + i) % this.entries.size();
            if (i >= this.limit || idxx >= this.entries.size()) break;
            SelectableEntry entry = this.entries.get(idxx);
            boolean selected = this.selected[idxx];
            boolean hovered = this.hovered == idxx;
            int entryY = this.method_46427() + i * (this.entryHeight + this.paddingY);
            entry.render(this, graphics, mouseX, mouseY, partialTick, this.method_46426(), entryY, selected, hovered);
        }
        if (this.scrollbar != null) {
            int scrollbarX = this.scrollbarDims()[0];
            if (this.entries.size() <= this.limit) {
                graphics.method_52706(this.scrollbar.disabled(), scrollbarX, this.method_46427() + this.scrollbar.topPadding(), this.scrollbar.width(), this.scrollbar.height());
            } else {
                float relative = (float)this.offset / (float)Math.max(0, this.entries.size() - this.limit);
                int y = this.method_46427() + (int)((float)(this.method_25364() - this.scrollbar.totalHeight()) * relative);
                graphics.method_52706(this.scrollbar.texture(), scrollbarX, y + this.scrollbar.topPadding(), this.scrollbar.width(), this.scrollbar.height());
            }
        }
    }

    protected int[] scrollbarDims() {
        if (this.scrollbar == null) {
            return null;
        }
        int minX = this.method_46426() + this.method_25368() - this.scrollbar.totalWidth() + this.scrollbar.leftPadding();
        int maxX = minX + this.scrollbar.width();
        int minY = this.method_46427() + this.scrollbar.topPadding();
        int maxY = minY + this.method_25364() - this.scrollbar.bottomPadding();
        return new int[]{minX, minY, maxX, maxY};
    }

    protected boolean inScrollBar(double mouseX, double mouseY) {
        if (this.scrollbar == null) {
            return false;
        }
        int[] dim = this.scrollbarDims();
        return mouseX >= (double)dim[0] && mouseY >= (double)dim[1] && mouseX < (double)dim[2] && mouseY < (double)dim[3];
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!super.method_25402(mouseX, mouseY, button)) {
            return false;
        }
        if (this.inScrollBar(mouseX, mouseY)) {
            this.mouseScrollDragging = true;
            return true;
        }
        int i = this.indexFromMouse(mouseX, mouseY);
        if (i != -1) {
            this.hoverOver(i);
            int entryX = this.method_46426();
            int entryY = this.method_46427() + i * (this.entryHeight + this.paddingY);
            double relMouseX = mouseX - (double)entryX;
            double relMouseY = mouseY - (double)entryY;
            SelectableEntry entry = this.select(this.hovered, true);
            if (!entry.onClick(relMouseX, relMouseY, this.selected[this.hovered])) {
                this.selected[this.hovered] = false;
            } else {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
        }
        return true;
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        return super.method_25361(mouseX, mouseY) && (this.indexFromMouse(mouseX, mouseY) != -1 || this.inScrollBar(mouseX, mouseY));
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.mouseScrollDragging = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.mouseScrollDragging) {
            int[] dims = this.scrollbarDims();
            double relativePos = mouseY - (double)dims[1];
            int height = dims[3] - dims[1];
            double relative = relativePos / (double)height;
            int max = Math.max(this.entries.size() - this.limit, 0);
            this.offset = class_3532.method_15340((int)((int)Math.round(relative * (double)max)), (int)0, (int)max);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean isMouseDragging() {
        return this.mouseScrollDragging;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        super.method_25401(mouseX, mouseY, scrollX, scrollY);
        if (this.field_22762) {
            this.offset = class_3532.method_15340((int)((int)((double)this.offset - scrollY)), (int)0, (int)Math.max(this.entries.size() - this.limit, 0));
            return true;
        }
        return false;
    }

    public void method_25354(class_1144 handler) {
    }

    protected void method_47399(class_6382 output) {
    }

    private int indexFromMouse(double mouseX, double mouseY) {
        if (mouseX >= (double)(this.method_46426() + this.getEntryWidth())) {
            return -1;
        }
        double relativePos = mouseY - (double)this.method_46427();
        if (relativePos < 0.0 || relativePos > (double)(this.method_46427() + this.field_22759)) {
            return -1;
        }
        int idx = (int)(relativePos / (double)(this.entryHeight + this.paddingY) + (double)this.offset);
        if (idx >= this.entries.size() || idx >= this.offset + this.limit) {
            return -1;
        }
        int entryY = (idx - this.offset) * (this.entryHeight + this.paddingY);
        if (relativePos < (double)entryY || relativePos > (double)(entryY + this.entryHeight)) {
            return -1;
        }
        return idx;
    }

    public void hoverOver(int index) {
        this.hovered = index;
        if (this.hovered != -1) {
            if (this.hovered < 0) {
                this.hovered += this.entries.size();
            }
            if (this.hovered >= this.entries.size()) {
                this.hovered -= this.entries.size();
            }
        }
    }

    public SelectableEntry select(int select, boolean toggle) {
        if (select < 0 || select >= this.entries.size()) {
            return null;
        }
        if (!this.canSelectMultiple && this.lastSelect != select) {
            this.selected[this.lastSelect] = false;
            this.entries.get(this.lastSelect).unSelect();
        }
        this.lastSelect = select;
        boolean previous = this.selected[select];
        this.selected[select] = !toggle || !this.selected[select];
        SelectableEntry entry = this.entries.get(select);
        if (previous && !this.selected[select]) {
            entry.unSelect();
        }
        return entry;
    }

    public void scrollTo(int offset) {
        this.offset = class_3532.method_15340((int)offset, (int)0, (int)Math.max(this.entries.size() - this.limit, 0));
    }

    public int getScrollValue() {
        return this.offset;
    }

    public class_327 getFont() {
        return this.font;
    }

    public record Scrollbar(class_2960 texture, class_2960 disabled, int width, int height, int leftPadding, int rightPadding, int topPadding, int bottomPadding) {
        public Scrollbar(class_2960 texture, class_2960 disabled, int width, int height) {
            this(texture, disabled, width, height, 0, 0, 0, 0);
        }

        public Scrollbar(class_2960 texture, class_2960 disabled, int width, int height, int leftPadding, int topPadding) {
            this(texture, disabled, width, height, leftPadding, 0, topPadding, 0);
        }

        public int totalWidth() {
            return this.width() + this.leftPadding() + this.rightPadding();
        }

        public int totalHeight() {
            return this.height() + this.topPadding() + this.bottomPadding();
        }
    }
}

