/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.particles.advanced;

import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.client.particles.advanced.AdvancedParticle;
import io.github.flemmli97.tenshilib.client.particles.advanced.AdvancedParticleHandler;
import io.github.flemmli97.tenshilib.client.particles.advanced.handler.CirclingHandler;
import io.github.flemmli97.tenshilib.client.particles.advanced.handler.ColorHandler;
import io.github.flemmli97.tenshilib.client.particles.advanced.handler.EntityFollowHandler;
import io.github.flemmli97.tenshilib.client.particles.advanced.handler.MotionHandler;
import io.github.flemmli97.tenshilib.client.particles.advanced.handler.MoveToHandler;
import io.github.flemmli97.tenshilib.client.particles.advanced.handler.ParticleMetaHandler;
import io.github.flemmli97.tenshilib.client.particles.advanced.handler.ScaleHandler;
import io.github.flemmli97.tenshilib.client.particles.advanced.handler.SinMotionHandler;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.ParticleHandlerType;
import io.github.flemmli97.tenshilib.common.registry.TenshilibParticleHandlerTypes;
import io.github.flemmli97.tenshilib.mixin.ParticleEngineAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_310;
import net.minecraft.class_702;
import net.minecraft.class_703;

public class AdvancedParticleRegistry {
    private static final Map<ParticleHandlerType<?>, Factory<?>> MAP = new HashMap();

    public static void init() {
        if (!TenshiLib.clientRequired()) {
            return;
        }
        AdvancedParticleRegistry.register((ParticleHandlerType)TenshilibParticleHandlerTypes.COLOR.get(), ColorHandler::new);
        AdvancedParticleRegistry.register((ParticleHandlerType)TenshilibParticleHandlerTypes.ENTITY_FOLLOW.get(), EntityFollowHandler::new);
        AdvancedParticleRegistry.register((ParticleHandlerType)TenshilibParticleHandlerTypes.MOTION.get(), MotionHandler::new);
        AdvancedParticleRegistry.register((ParticleHandlerType)TenshilibParticleHandlerTypes.SIN_MOTION.get(), SinMotionHandler::new);
        AdvancedParticleRegistry.register((ParticleHandlerType)TenshilibParticleHandlerTypes.MOVE_TO.get(), MoveToHandler::new);
        AdvancedParticleRegistry.register((ParticleHandlerType)TenshilibParticleHandlerTypes.PARTICLE_META.get(), ParticleMetaHandler::new);
        AdvancedParticleRegistry.register((ParticleHandlerType)TenshilibParticleHandlerTypes.SCALE.get(), ScaleHandler::new);
        AdvancedParticleRegistry.register((ParticleHandlerType)TenshilibParticleHandlerTypes.CIRLING.get(), CirclingHandler::new);
    }

    public static synchronized <T extends AdvancedParticleData> void register(ParticleHandlerType<T> type, Factory<T> factory) {
        if (MAP.put(type, factory) != null) {
            throw new IllegalStateException("Type already registered " + String.valueOf(type));
        }
    }

    private static <T extends AdvancedParticleData> AdvancedParticleHandler create(T data, class_703 particle) {
        Factory<?> factory = MAP.get(data.getType());
        if (factory == null) {
            throw new IllegalStateException("Type not registered " + String.valueOf(data.getType()));
        }
        return factory.create(data, particle);
    }

    public static void verify() {
        if (!TenshiLib.clientRequired()) {
            return;
        }
        ArrayList missing = new ArrayList();
        TenshilibParticleHandlerTypes.PARTICLE_HANDLER_TYPES.registry().forEach(t -> {
            if (!MAP.containsKey(t)) {
                missing.add(t);
            }
        });
        if (!missing.isEmpty()) {
            throw new IllegalStateException("Unregistered handlers for " + String.valueOf(missing));
        }
    }

    public static void createParticle(AdvancedParticleContainer container, double x, double y, double z) {
        class_702 engine = class_310.method_1551().field_1713;
        class_703 inner = ((ParticleEngineAccessor)engine).makeParticleInvoker(container.options(), x, y, z, 0.0, 0.0, 0.0);
        inner.method_3063(x, y, z);
        inner.method_34753(0.0, 0.0, 0.0);
        ArrayList<AdvancedParticleHandler> list = new ArrayList<AdvancedParticleHandler>();
        for (AdvancedParticleData data : container.data()) {
            try {
                list.add(AdvancedParticleRegistry.create(data, inner));
            }
            catch (IllegalStateException e) {
                TenshiLib.LOGGER.error((Object)e);
            }
        }
        AdvancedParticle particle = new AdvancedParticle(inner, list, class_310.method_1551().field_1687, x, y, z);
        engine.method_3058((class_703)particle);
    }

    public static interface Factory<T extends AdvancedParticleData> {
        public AdvancedParticleHandler create(T var1, class_703 var2);
    }
}

