/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public abstract class TextureRenderer<T extends class_1297>
extends class_897<T> {
    public final float xSize;
    public final float ySize;
    public final int rows;
    public final int columns;
    public final int length;
    public final float uLength;
    public final float vLength;
    protected final RenderUtils.TextureBuilder textureBuilder = new RenderUtils.TextureBuilder();

    public TextureRenderer(class_5617.class_5618 ctx, float xSize, float ySize, int rows, int columns) {
        super(ctx);
        this.xSize = xSize;
        this.ySize = ySize;
        this.rows = rows;
        this.columns = columns;
        this.length = rows * columns;
        this.uLength = 1.0f / (float)columns;
        this.vLength = 1.0f / (float)rows;
        this.textureBuilder.setUVLength(this.uLength, this.vLength);
    }

    public void setColor(int hexColor) {
        this.textureBuilder.setColor(hexColor);
    }

    public void setColor(int red, int green, int blue, int alpha) {
        this.textureBuilder.setColor(red, green, blue, alpha);
    }

    public void method_3936(T entity, float rotation, float partialTicks, class_4587 stack, class_4597 buffer, int packedLight) {
        float yaw = ((class_1297)entity).field_5982 + (entity.method_36454() - ((class_1297)entity).field_5982) * partialTicks + 180.0f;
        float pitch = ((class_1297)entity).field_6004 + (entity.method_36455() - ((class_1297)entity).field_6004) * partialTicks;
        this.adjustYawPitch(stack, entity, partialTicks, yaw, pitch);
        float[] uvOffset = this.uvOffset(((class_1297)entity).field_6012);
        this.textureBuilder.setUV(uvOffset[0], uvOffset[1]);
        this.textureBuilder.setLight(packedLight);
        this.doRender(entity, partialTicks, stack, buffer);
        super.method_3936(entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public void doRender(T entity, float partialTicks, class_4587 stack, class_4597 buffer) {
        RenderUtils.renderTexture(stack, buffer.getBuffer(this.getRenderType(entity, this.method_3931((class_1297)entity))), this.xSize, this.ySize, this.textureBuilder);
    }

    public void adjustYawPitch(class_4587 stack, T entity, float partialTicks, float yaw, float pitch) {
        if (this.facePlayer()) {
            stack.method_22907(this.field_4676.method_24197());
            stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        } else {
            RenderUtils.applyYawPitch(stack, yaw + this.yawOffset(), -pitch + this.pitchOffset());
        }
    }

    protected class_1921 getRenderType(T entity, class_2960 loc) {
        return class_1921.method_23578((class_2960)loc);
    }

    public boolean facePlayer() {
        return true;
    }

    public float yawOffset() {
        return 0.0f;
    }

    public float pitchOffset() {
        return 0.0f;
    }

    public float[] uvOffset(int timer) {
        int frame = timer % this.length;
        return new float[]{(float)(frame % this.columns) * this.uLength, (float)frame / (float)this.columns * this.vLength};
    }
}

