/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain.data;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.minecraft.class_5819;
import net.minecraft.class_6007;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import org.jetbrains.annotations.Nullable;

public class AnimationPlayHolder<T extends class_1308> {
    private final String animation;
    private final List<ChainedAnimations<T>> chainedActions;
    private final float chainChance;

    public AnimationPlayHolder(String animation) {
        this(animation, null, 1.0f);
    }

    private AnimationPlayHolder(String animation, List<ChainedAnimations<T>> chainedActions, float chainChance) {
        this.animation = animation;
        this.chainedActions = chainedActions;
        this.chainChance = chainChance;
    }

    public static <T extends class_1308> Builder<T> builder(String animation) {
        return new Builder(animation);
    }

    public String animation() {
        return this.animation;
    }

    @Nullable
    public List<AnimationHolder> get(T mob) {
        if (this.chainedActions == null) {
            return null;
        }
        if (mob.method_59922().method_43057() >= this.chainChance) {
            return null;
        }
        List<ChainedAnimations> filtered = this.chainedActions.stream().filter(d -> d.predicate().test((class_1308)mob)).toList();
        return class_6011.method_34986((class_5819)mob.method_59922(), filtered).map(ChainedAnimations::chains).orElse(null);
    }

    public String toString() {
        return this.animation;
    }

    public static class Builder<T extends class_1308> {
        private final String animation;
        private final List<ChainedAnimations.ChainListBuilder<T>> anims = new ArrayList<ChainedAnimations.ChainListBuilder<T>>();
        private float chance = 1.0f;

        private Builder(String animation) {
            this.animation = animation;
        }

        public Builder<T> chainChance(float chance) {
            this.chance = chance;
            return this;
        }

        public Builder<T> start(String anim) {
            return this.start(anim, e -> true);
        }

        public Builder<T> start(String anim, Predicate<T> predicate) {
            return this.start(anim, -1, 0.0f, 1, predicate);
        }

        public Builder<T> start(String anim, int transitionTime, float offset, int weight) {
            return this.start(anim, transitionTime, offset, weight, e -> true);
        }

        public Builder<T> start(String anim, int transitionTime, float offset, int weight, Predicate<T> predicate) {
            this.anims.add(new ChainedAnimations.ChainListBuilder<T>(new AnimationHolder(anim, transitionTime, offset * 20.0f), weight, predicate));
            return this;
        }

        public Builder<T> chain(String anim) {
            return this.chain(anim, -1, 0.0f);
        }

        public Builder<T> chain(String anim, int transitionTime, float offset) {
            this.anims.getLast().add(new AnimationHolder(anim, transitionTime, offset * 20.0f));
            return this;
        }

        public AnimationPlayHolder<T> build() {
            return new AnimationPlayHolder(this.animation, this.anims.stream().map(ChainedAnimations.ChainListBuilder::build).toList(), this.chance);
        }
    }

    private record ChainedAnimations<T extends class_1308>(List<AnimationHolder> chains, class_6007 weight, Predicate<T> predicate) implements class_6008
    {
        public class_6007 method_34979() {
            return this.weight();
        }

        private static class ChainListBuilder<T extends class_1308> {
            private final ImmutableList.Builder<AnimationHolder> chains = new ImmutableList.Builder();
            private final int weight;
            private final Predicate<T> predicate;

            private ChainListBuilder(AnimationHolder action, int weight, Predicate<T> predicate) {
                this.weight = weight;
                this.chains.add((Object)action);
                this.predicate = predicate;
            }

            public void add(AnimationHolder action) {
                this.chains.add((Object)action);
            }

            public ChainedAnimations<T> build() {
                return new ChainedAnimations<T>((List<AnimationHolder>)this.chains.build(), class_6007.method_34977((int)this.weight), this.predicate);
            }
        }
    }

    public record AnimationHolder(String animation, int transitionTime, float offset) {
        public AnimationHolder(String animation) {
            this(animation, 3, 0.0f);
        }
    }
}

