/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.fabric.attachment;

import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.common.attachment.AttachmentTransferHandler;
import io.github.flemmli97.tenshilib.common.attachment.AttachmentType;
import io.github.flemmli97.tenshilib.common.attachment.SerializableAttachment;
import io.github.flemmli97.tenshilib.fabric.attachment.AttachmentHolder;
import io.github.flemmli97.tenshilib.fabric.loader.registry.AttachmentRegisterImpl;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

public class AttachmentHandler {
    public static final String TAG_KEY = "tenshilib:Attachments";

    public static void copyAttachments(Object from, Object to, boolean wasDeath) {
        if (!(from instanceof AttachmentHolder) || !(to instanceof AttachmentHolder)) {
            return;
        }
        AttachmentRegisterImpl.REGISTRY.forEach(type -> {
            AttachmentTransferHandler handler = type.transferHandler().orElse(null);
            if (handler != null) {
                AttachmentType attachmentType = type;
                Object newAttachment = handler.copy(((AttachmentHolder)from).tenshilib$getAttachment(type), to, wasDeath);
                if (newAttachment != null) {
                    ((AttachmentHolder)to).tenshilib$setAttachment(attachmentType, newAttachment);
                }
            }
        });
    }

    public static IdentityHashMap<AttachmentType<?>, Object> readAttachments(Object holder, class_2487 tag, class_7225.class_7874 provider) {
        IdentityHashMap map = new IdentityHashMap();
        for (String key : tag.method_10541()) {
            AttachmentType type = (AttachmentType)AttachmentRegisterImpl.REGISTRY.method_10223(class_2960.method_60654((String)key));
            if (type == null) {
                TenshiLib.LOGGER.warn("No such attachment type {} registered!", (Object)key);
                continue;
            }
            Object attachment = type.defaultValueSupplier().apply(holder);
            if (!(attachment instanceof SerializableAttachment)) continue;
            SerializableAttachment ser = (SerializableAttachment)attachment;
            try {
                ser.read(tag.method_10580(key), provider);
                map.put(type, attachment);
            }
            catch (Exception exception) {
                TenshiLib.LOGGER.warn("Could not read attachment {}!", (Object)key, (Object)exception);
            }
        }
        return map;
    }

    public static class_2487 saveAttachments(IdentityHashMap<AttachmentType<?>, ?> attachments, class_7225.class_7874 provider) {
        if (attachments.isEmpty()) {
            return null;
        }
        class_2487 tag = new class_2487();
        for (Map.Entry<AttachmentType<?>, ?> entry : attachments.entrySet()) {
            SerializableAttachment ser;
            Object tagEntry;
            class_2960 key = AttachmentRegisterImpl.REGISTRY.method_10221(entry.getKey());
            if (key == null) {
                TenshiLib.LOGGER.warn("Attachment type {} is not registered!", entry.getKey());
                continue;
            }
            Object obj = entry.getValue();
            if (!(obj instanceof SerializableAttachment) || (tagEntry = (ser = (SerializableAttachment)obj).write(provider)) == null) continue;
            tag.method_10566(key.toString(), tagEntry);
        }
        if (tag.method_33133()) {
            return null;
        }
        return tag;
    }
}

