/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.animation.Animation;
import io.github.flemmli97.tenshilib.client.model.animation.AnimationBone;
import io.github.flemmli97.tenshilib.client.model.animation.keyframe.BoneKeyFrame;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.utils.math.parser.VariableMap;
import io.github.flemmli97.tenshilib.mixinhelper.EntityRenderDispatcherAccess;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class BedrockAnimations {
    public static final Gson GSON = new GsonBuilder().setLenient().registerTypeAdapter(BedrockAnimations.class, BedrockAnimations.deserializer()).create();
    protected final Map<String, Animation> animations;
    private final VariableMap variables = new VariableMap();

    private BedrockAnimations(Map<String, Animation> animations) {
        this.animations = animations;
    }

    private static JsonDeserializer<BedrockAnimations> deserializer() {
        return (json, type, ctx) -> {
            JsonObject obj = json.getAsJsonObject();
            JsonObject animations = class_3518.method_15281((JsonObject)obj, (String)"animations", (JsonObject)new JsonObject());
            HashMap map = new HashMap();
            animations.asMap().forEach((key, e) -> {
                JsonObject animObj = e.getAsJsonObject();
                double length = class_3518.method_34915((JsonObject)animObj, (String)"animation_length", (double)0.0) * 20.0;
                boolean loop = class_3518.method_15258((JsonObject)animObj, (String)"loop", (boolean)false);
                map.put(key, new Animation(length, loop, AnimationBone.parseBones(class_3518.method_15281((JsonObject)animObj, (String)"bones", (JsonObject)new JsonObject())), Animation.parseParticles(class_3518.method_15281((JsonObject)animObj, (String)"particle_effects", (JsonObject)new JsonObject())), Animation.parseSound(class_3518.method_15281((JsonObject)animObj, (String)"sound_effects", (JsonObject)new JsonObject())), Animation.parseMarkers(class_3518.method_15281((JsonObject)animObj, (String)"timeline", (JsonObject)new JsonObject()))));
            });
            return new BedrockAnimations(Map.copyOf(map));
        };
    }

    public static BedrockAnimations empty() {
        return new BedrockAnimations(Map.of());
    }

    public static float wrapDegrees(float value) {
        float f = value % 360.0f;
        if (f < 0.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static float degreeDiff(float current, float target) {
        float diff = target - current;
        if (diff > 180.0f) {
            diff -= 360.0f;
        } else if (diff < -180.0f) {
            diff += 360.0f;
        }
        return diff;
    }

    public void doAnimation(ExtendedModel model, String name, int ticker, float partialTicks) {
        this.doAnimation(model, name, ticker, partialTicks, 1.0f);
    }

    public void doAnimation(ExtendedModel model, String name, int ticker, float partialTicks, float interpolation) {
        this.doAnimation(model, name, ticker, partialTicks, interpolation, false, false);
    }

    public boolean doAnimation(ExtendedModel model, String name, int ticker, float partialTicks, float interpolation, boolean mirror, boolean add) {
        return this.doAnimation(model, name, Math.max((float)(ticker - 1) + partialTicks, 0.0f), interpolation, mirror, add);
    }

    public boolean doAnimation(ExtendedModel model, AnimationHandler<?> handler, float partialTicks) {
        return this.doAnimation(model, handler, partialTicks, false);
    }

    public boolean doAnimation(ExtendedModel model, AnimationHandler<?> handler, float partialTicks, boolean mirror) {
        return this.doAnimation(model, handler, partialTicks, a -> mirror, null);
    }

    public boolean doAnimation(ExtendedModel model, AnimationHandler<?> handler, float partialTicks, @Nullable Predicate<AnimationState> mirror, @Nullable Function<AnimationState, String> animationID) {
        AnimationState current = handler.getAnimation();
        AnimationState last = handler.getLastAnimation();
        float interpolationLast = handler.getLastTransitionProgress(partialTicks);
        float interpolation = handler.getCurrentTransitionProgress(partialTicks);
        boolean changed = false;
        if (last != null && interpolationLast > 0.0f) {
            changed = this.doAnimation(model, animationID != null ? animationID.apply(last) : last.getAnimation(), last.getTick(partialTicks), interpolationLast, mirror != null && mirror.test(last), false);
        }
        if (current != null && this.doAnimation(model, animationID != null ? animationID.apply(current) : current.getAnimation(), current.getTick(partialTicks), interpolation, mirror != null && mirror.test(current), false) && !changed) {
            changed = true;
        }
        return changed;
    }

    public boolean doAnimation(ExtendedModel model, String name, float tick, float interpolation, boolean mirror, boolean add) {
        Animation animation = this.animations.get(name);
        if (animation != null && interpolation != 0.0f) {
            this.animate(model, animation, tick, class_3532.method_15363((float)interpolation, (float)0.0f, (float)1.0f), mirror, add);
            return true;
        }
        return false;
    }

    public void runSpecialEffects(class_1297 entity, class_4587 stack, String animationID, DoublePredicate applies, ExtendedModel model) {
        Animation animation = this.animations.get(animationID);
        if (animation == null) {
            return;
        }
        animation.particleFrames().forEach(frame -> {
            class_2394 particle;
            if (applies.test(frame.startTick) && (particle = frame.getParticle(entity.method_37908().method_30349())) != null) {
                if (frame.locator.isEmpty()) {
                    class_310.method_1551().field_1713.method_3056(particle, entity.method_23317(), entity.method_23318(), entity.method_23321(), 0.0, 0.0, 0.0);
                } else {
                    ModelPartsContainer.ModelPartExtended anchor = model.getModel().getPart(frame.locator);
                    if (anchor != null) {
                        stack.method_22903();
                        anchor.translateAndRotateWithParents(stack);
                        class_243 pos = EntityRenderDispatcherAccess.toWorldPosition(entity, stack.method_23760().method_23761());
                        class_310.method_1551().field_1713.method_3056(particle, pos.method_10216(), pos.method_10214(), pos.method_10215(), 0.0, 0.0, 0.0);
                        stack.method_22909();
                    }
                }
            }
        });
        animation.soundFrames().forEach(frame -> {
            class_6880<class_3414> sound;
            if (applies.test(frame.startTick) && (sound = frame.getSound(entity.method_37908().method_30349())) != null) {
                class_310.method_1551().field_1687.method_55116(entity, (class_3414)sound.comp_349(), entity.method_5634(), 1.0f, 1.0f);
            }
        });
    }

    public void runTimelineEffects(String animationID, String effect, DoublePredicate applies, Runnable run) {
        Animation animation = this.animations.get(animationID);
        if (animation == null) {
            return;
        }
        double[] times = animation.markerFrames().get(effect);
        if (times == null) {
            return;
        }
        for (double d : times) {
            if (!applies.test(d)) continue;
            run.run();
        }
    }

    public double animationLength(String name) {
        Animation animation = this.animations.get(name);
        return animation != null ? animation.length() : 0.0;
    }

    public boolean has(String name) {
        return this.animations.containsKey(name);
    }

    public void setVariable(String variable, double value) {
        this.variables.setVariable(variable, value);
    }

    public void setVariable(String variable, DoubleSupplier value) {
        this.variables.setVariable(variable, value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Animation: ");
        this.animations.forEach((key, anim) -> builder.append(String.format("\n%s = %s", key, anim)));
        return builder.toString();
    }

    private void animate(ExtendedModel model, Animation animation, float tick, float interpolation, boolean mirror, boolean add) {
        if (animation.loop() && animation.length() > 0.0) {
            tick = (float)((double)tick % animation.length());
        }
        for (AnimationBone bone : animation.bones().values()) {
            this.animateBone(model, bone, tick, interpolation, mirror, add);
        }
    }

    private void animateBone(ExtendedModel model, AnimationBone bone, float actualTick, float interpolation, boolean mirror, boolean add) {
        float dZ;
        float dY;
        float dX;
        float z;
        float y;
        float x;
        float prog;
        float dZ2;
        float dY2;
        float dX2;
        float z2;
        float y2;
        float x2;
        ModelPartsContainer.ModelPartExtended mirrored;
        ModelPartsContainer.ModelPartExtended modelPart = model.getModel().getPartNullable(bone.name());
        if (mirror && (mirrored = model.getModel().getPartNullable(bone.mirroredName())) != null) {
            modelPart = mirrored;
        }
        if (modelPart == null) {
            return;
        }
        this.variables.setVariable("query.anim_time", (double)actualTick * 0.05);
        float mirrorMult = mirror ? -1 : 1;
        if (!bone.translations().isEmpty()) {
            if (bone.translations().size() == 1) {
                x2 = bone.translations().getFirst().getXVal(this.variables) * mirrorMult;
                y2 = bone.translations().getFirst().getYVal(this.variables);
                z2 = bone.translations().getFirst().getZVal(this.variables);
                dX2 = add ? 0.0f : modelPart.x - modelPart.getDefaultPose().x;
                modelPart.x += (x2 - dX2) * interpolation;
                dY2 = add ? 0.0f : modelPart.y - modelPart.getDefaultPose().y;
                modelPart.y -= (y2 + dY2) * interpolation;
                dZ2 = add ? 0.0f : modelPart.z - modelPart.getDefaultPose().z;
                modelPart.z += (z2 - dZ2) * interpolation;
            } else {
                BoneKeyFrame current;
                BoneKeyFrame next = current = bone.translations().getFirst();
                for (int i = 1; i < bone.translations().size() && (double)actualTick >= next.startTick; ++i) {
                    current = next;
                    next = bone.translations().get(i);
                }
                prog = (float)class_3532.method_15350((double)(((double)actualTick - current.startTick) / (next.startTick - current.startTick)), (double)0.0, (double)1.0);
                x = this.interpolate(current.getXVal(this.variables), next.getXVal(this.variables), prog) * mirrorMult;
                y = this.interpolate(current.getYVal(this.variables), next.getYVal(this.variables), prog);
                z = this.interpolate(current.getZVal(this.variables), next.getZVal(this.variables), prog);
                dX = add ? 0.0f : modelPart.x - modelPart.getDefaultPose().x;
                modelPart.x += (x - dX) * interpolation;
                dY = add ? 0.0f : modelPart.y - modelPart.getDefaultPose().y;
                modelPart.y -= (y + dY) * interpolation;
                dZ = add ? 0.0f : modelPart.z - modelPart.getDefaultPose().z;
                modelPart.z += (z - dZ) * interpolation;
            }
        }
        if (!bone.rotations().isEmpty()) {
            if (bone.rotations().size() == 1) {
                x2 = BedrockAnimations.wrapDegrees(bone.rotations().getFirst().getXVal(this.variables));
                y2 = BedrockAnimations.wrapDegrees(bone.rotations().getFirst().getYVal(this.variables)) * mirrorMult;
                z2 = BedrockAnimations.wrapDegrees(bone.rotations().getFirst().getZVal(this.variables)) * mirrorMult;
                dX2 = add ? 0.0f : BedrockAnimations.wrapDegrees(57.295776f * (modelPart.xRot - modelPart.getDefaultPose().xRot));
                modelPart.xRot += (float)Math.PI / 180 * BedrockAnimations.degreeDiff(dX2, x2) * interpolation;
                dY2 = add ? 0.0f : BedrockAnimations.wrapDegrees(57.295776f * (modelPart.yRot - modelPart.getDefaultPose().yRot));
                modelPart.yRot += (float)Math.PI / 180 * BedrockAnimations.degreeDiff(dY2, y2) * interpolation;
                dZ2 = add ? 0.0f : BedrockAnimations.wrapDegrees(57.295776f * (modelPart.zRot - modelPart.getDefaultPose().zRot));
                modelPart.zRot += (float)Math.PI / 180 * BedrockAnimations.degreeDiff(dZ2, z2) * interpolation;
            } else {
                BoneKeyFrame current;
                BoneKeyFrame next = current = bone.rotations().getFirst();
                for (int i = 1; i < bone.rotations().size() && (double)actualTick >= next.startTick; ++i) {
                    current = next;
                    next = bone.rotations().get(i);
                }
                prog = (float)class_3532.method_15350((double)(((double)actualTick - current.startTick) / (next.startTick - current.startTick)), (double)0.0, (double)1.0);
                x = BedrockAnimations.wrapDegrees(this.interpolate(current.getXVal(this.variables), next.getXVal(this.variables), prog));
                y = BedrockAnimations.wrapDegrees(this.interpolate(current.getYVal(this.variables), next.getYVal(this.variables), prog)) * mirrorMult;
                z = BedrockAnimations.wrapDegrees(this.interpolate(current.getZVal(this.variables), next.getZVal(this.variables), prog)) * mirrorMult;
                dX = add ? 0.0f : BedrockAnimations.wrapDegrees(57.295776f * (modelPart.xRot - modelPart.getDefaultPose().xRot));
                modelPart.xRot += (float)Math.PI / 180 * BedrockAnimations.degreeDiff(dX, x) * interpolation;
                dY = add ? 0.0f : BedrockAnimations.wrapDegrees(57.295776f * (modelPart.yRot - modelPart.getDefaultPose().yRot));
                modelPart.yRot += (float)Math.PI / 180 * BedrockAnimations.degreeDiff(dY, y) * interpolation;
                dZ = add ? 0.0f : BedrockAnimations.wrapDegrees(57.295776f * (modelPart.zRot - modelPart.getDefaultPose().zRot));
                modelPart.zRot += (float)Math.PI / 180 * BedrockAnimations.degreeDiff(dZ, z) * interpolation;
            }
        }
        if (!bone.scales().isEmpty()) {
            if (bone.scales().size() == 1) {
                float x3 = bone.scales().getFirst().getXVal(this.variables) - modelPart.getDefaultPose().xScale;
                float y3 = bone.scales().getFirst().getYVal(this.variables) - modelPart.getDefaultPose().yScale;
                z2 = bone.scales().getFirst().getZVal(this.variables) - modelPart.getDefaultPose().zScale;
                dX2 = add ? 0.0f : modelPart.xScale - modelPart.getDefaultPose().xScale;
                modelPart.xScale += (x3 - dX2) * interpolation;
                dY2 = add ? 0.0f : modelPart.yScale - modelPart.getDefaultPose().yScale;
                modelPart.yScale += (y3 - dY2) * interpolation;
                dZ2 = add ? 0.0f : modelPart.zScale - modelPart.getDefaultPose().zScale;
                modelPart.zScale += (z2 - dZ2) * interpolation;
            } else {
                BoneKeyFrame current;
                BoneKeyFrame next = current = bone.scales().getFirst();
                for (int i = 1; i < bone.scales().size() && (double)actualTick >= next.startTick; ++i) {
                    current = next;
                    next = bone.scales().get(i);
                }
                float prog2 = (float)class_3532.method_15350((double)(((double)actualTick - current.startTick) / (next.startTick - current.startTick)), (double)0.0, (double)1.0);
                x = this.interpolate(current.getXVal(this.variables), next.getXVal(this.variables), prog2) - modelPart.getDefaultPose().xScale;
                y = this.interpolate(current.getYVal(this.variables), next.getYVal(this.variables), prog2) - modelPart.getDefaultPose().yScale;
                z = this.interpolate(current.getZVal(this.variables), next.getZVal(this.variables), prog2) - modelPart.getDefaultPose().zScale;
                dX = add ? 0.0f : modelPart.xScale - modelPart.getDefaultPose().xScale;
                modelPart.xScale += (x - dX) * interpolation;
                dY = add ? 0.0f : modelPart.yScale - modelPart.getDefaultPose().yScale;
                modelPart.yScale += (y - dY) * interpolation;
                dZ = add ? 0.0f : modelPart.zScale - modelPart.getDefaultPose().zScale;
                modelPart.zScale += (z - dZ) * interpolation;
            }
        }
    }

    private float interpolate(float start, float end, float progress) {
        return start + (end - start) * progress;
    }
}

