/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.model;

import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import io.github.flemmli97.tenshilib.mixin.ModelPartAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import net.minecraft.class_7833;

public class ModelPartsContainer {
    private final ModelPartExtended root;
    private final Map<String, ModelPartExtended> childrenToName = new HashMap<String, ModelPartExtended>();

    public ModelPartsContainer(class_630 root) {
        this.root = new ModelPartExtended("model_root", null, root);
        this.childrenToName.put("model_root", this.root);
        this.root.getMappedParts(this.childrenToName);
    }

    public ModelPartExtended getPart(String name) {
        ModelPartExtended modelPart = this.childrenToName.get(name);
        if (modelPart == null) {
            throw new NoSuchElementException("Can't find part " + name);
        }
        return modelPart;
    }

    public Optional<ModelPartExtended> getOptionalPart(String name) {
        return Optional.ofNullable(this.childrenToName.get(name));
    }

    protected ModelPartExtended getPartNullable(String name) {
        return this.childrenToName.get(name);
    }

    public void resetPoses() {
        this.root.resetAll();
    }

    public ModelPartExtended getRoot() {
        return this.root;
    }

    public static class ModelPartExtended {
        private final String name;
        private final ModelPartExtended parent;
        public float x;
        public float y;
        public float z;
        public float xRot;
        public float yRot;
        public float zRot;
        public float xScale = 1.0f;
        public float yScale = 1.0f;
        public float zScale = 1.0f;
        public boolean visible = true;
        private final List<class_630.class_628> cubes;
        private final Map<String, ModelPartExtended> children;
        private PoseExtended defaultPose;

        public ModelPartExtended(String name, ModelPartExtended parent, class_630 orig) {
            this.name = name;
            this.parent = parent;
            this.cubes = ((ModelPartAccessor)orig).getCubes();
            this.children = ((ModelPartAccessor)orig).getChildren().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ModelPartExtended((String)e.getKey(), this, (class_630)e.getValue())));
            this.updateDefaultPose(new PoseExtended(orig.method_32084()));
        }

        public class_5603 storePose() {
            return class_5603.method_32091((float)this.x, (float)this.y, (float)this.z, (float)this.xRot, (float)this.yRot, (float)this.zRot);
        }

        public PoseExtended extendedPose() {
            return new PoseExtended(this.x, this.y, this.z, this.xRot, this.yRot, this.zRot, this.xScale, this.yScale, this.zScale);
        }

        public void loadPose(class_5603 partPose) {
            this.setPos(partPose.field_27702, partPose.field_27703, partPose.field_27704);
            this.setRotation(partPose.field_27705, partPose.field_27706, partPose.field_27707);
        }

        public void loadPose(PoseExtended pose) {
            this.setPos(pose.x, pose.y, pose.z);
            this.setRotation(pose.xRot, pose.yRot, pose.zRot);
            this.setScale(pose.xScale, pose.yScale, pose.zScale);
        }

        public void loadPoseRecursive(PoseExtended pose) {
            this.setPos(pose.x, pose.y, pose.z);
            this.setRotation(pose.xRot, pose.yRot, pose.zRot);
            this.setScale(pose.xScale, pose.yScale, pose.zScale);
            this.children.values().forEach((? super T m) -> m.loadPoseRecursive(pose));
        }

        public ModelPartExtended getChild(String string) {
            ModelPartExtended modelPart = this.children.get(string);
            if (modelPart == null) {
                throw new NoSuchElementException("Can't find part " + string);
            }
            return modelPart;
        }

        public void setPos(float f, float g, float h) {
            this.x = f;
            this.y = g;
            this.z = h;
        }

        public void setRotation(float f, float g, float h) {
            this.xRot = f;
            this.yRot = g;
            this.zRot = h;
        }

        public void setScale(float x, float y, float z) {
            this.xScale = x;
            this.yScale = y;
            this.zScale = z;
        }

        public void reset() {
            this.loadPose(this.getDefaultPose());
        }

        public void resetAll() {
            this.reset();
            this.children.values().forEach(ModelPartExtended::resetAll);
        }

        public void setAllVisible(boolean visible) {
            this.visible = visible;
            this.children.values().forEach((? super T m) -> m.setAllVisible(visible));
        }

        public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j) {
            this.render(poseStack, vertexConsumer, i, j, -1);
        }

        public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j, int color) {
            if (!(!this.visible || this.cubes.isEmpty() && this.children.isEmpty())) {
                poseStack.method_22903();
                this.translateAndRotate(poseStack);
                this.compile(poseStack.method_23760(), vertexConsumer, i, j, color);
                for (ModelPartExtended modelPart : this.children.values()) {
                    modelPart.render(poseStack, vertexConsumer, i, j, color);
                }
                poseStack.method_22909();
            }
        }

        public void renderForced(class_4587 poseStack, class_4588 vertexConsumer, int i, int j, int color) {
            if (!this.cubes.isEmpty() || !this.children.isEmpty()) {
                poseStack.method_22903();
                this.translateAndRotate(poseStack);
                if (this.visible) {
                    this.compile(poseStack.method_23760(), vertexConsumer, i, j, color);
                }
                for (ModelPartExtended modelPart : this.children.values()) {
                    modelPart.renderForced(poseStack, vertexConsumer, i, j, color);
                }
                poseStack.method_22909();
            }
        }

        public void visit(class_4587 poseStack, class_630.class_6229 visitor) {
            this.visit(poseStack, visitor, "");
        }

        private void visit(class_4587 poseStack, class_630.class_6229 visitor, String string) {
            if (!this.cubes.isEmpty() || !this.children.isEmpty()) {
                poseStack.method_22903();
                this.translateAndRotate(poseStack);
                class_4587.class_4665 pose = poseStack.method_23760();
                for (int i = 0; i < this.cubes.size(); ++i) {
                    visitor.method_35748(pose, string, i, this.cubes.get(i));
                }
                String string2 = string + "/";
                this.children.forEach((? super K string2x, ? super V modelPart) -> modelPart.visit(poseStack, visitor, string2 + string2x));
                poseStack.method_22909();
            }
        }

        public void translateAndRotateWithParents(class_4587 poseStack) {
            this.translateAndRotateWithParents(poseStack, false);
        }

        public void translateAndRotateWithParents(class_4587 poseStack, boolean excludeSelf) {
            ModelPartExtended part;
            ModelPartExtended modelPartExtended = part = excludeSelf ? this.parent : this;
            if (part == null) {
                return;
            }
            ArrayList<ModelPartExtended> parts = new ArrayList<ModelPartExtended>();
            parts.add(part);
            while (part.parent != null) {
                part = part.parent;
                parts.add(part);
            }
            for (int i = parts.size() - 1; i >= 0; --i) {
                ((ModelPartExtended)parts.get(i)).translateAndRotate(poseStack);
            }
        }

        public void translateAndRotate(class_4587 poseStack) {
            poseStack.method_46416(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
            if (this.zRot != 0.0f) {
                poseStack.method_22907(class_7833.field_40718.rotation(this.zRot));
            }
            if (this.yRot != 0.0f) {
                poseStack.method_22907(class_7833.field_40716.rotation(this.yRot));
            }
            if (this.xRot != 0.0f) {
                poseStack.method_22907(class_7833.field_40714.rotation(this.xRot));
            }
            if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
                poseStack.method_22905(this.xScale, this.yScale, this.zScale);
            }
        }

        private void compile(class_4587.class_4665 pose, class_4588 vertexConsumer, int i, int j, int color) {
            if (class_5253.class_5254.method_27762((int)color) == 0) {
                return;
            }
            for (class_630.class_628 cube : this.cubes) {
                cube.method_32089(pose, vertexConsumer, i, j, color);
            }
        }

        public class_630.class_628 getRandomCube(Random random) {
            return this.cubes.get(random.nextInt(this.cubes.size()));
        }

        public boolean isEmpty() {
            return this.cubes.isEmpty();
        }

        public void getMappedParts(Map<String, ModelPartExtended> map) {
            this.children.forEach((? super K key, ? super V value) -> {
                if (map.containsKey(key)) {
                    throw new IllegalStateException("Part with name " + key + " already exists!");
                }
                map.put((String)key, (ModelPartExtended)value);
                value.getMappedParts(map);
            });
        }

        public void forEach(BiConsumer<String, ModelPartExtended> consumer) {
            this.children.forEach((? super K name, ? super V part) -> {
                consumer.accept((String)name, (ModelPartExtended)part);
                part.forEach(consumer);
            });
        }

        public PoseExtended getDefaultPose() {
            return this.defaultPose;
        }

        public void updateDefaultPose(PoseExtended defaultPose) {
            this.defaultPose = defaultPose;
        }

        public String toString() {
            return String.format("Part: %s, Pos:[%s,%s,%s] - Rot:[%s,%s,%s] - Scale[%s,%s,%s]", this.name, Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.xRot), Float.valueOf(this.yRot), Float.valueOf(this.zRot), Float.valueOf(this.xScale), Float.valueOf(this.yScale), Float.valueOf(this.zScale));
        }
    }
}

