/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.particles.advanced.handler;

import io.github.flemmli97.tenshilib.client.particles.advanced.AdvancedParticleHandler;
import io.github.flemmli97.tenshilib.common.particle.data.CirclingData;
import io.github.flemmli97.tenshilib.mixin.ParticleAccessor;
import net.minecraft.class_243;
import net.minecraft.class_703;
import org.joml.Vector3d;

public class CirclingHandler
implements AdvancedParticleHandler {
    private final CirclingData data;
    private final double initOffX;
    private final double initOffY;
    private Vector3d last;
    private double angle;
    private double radius;
    private double centerX;
    private double centerY;
    private double centerZ;

    public CirclingHandler(CirclingData data, class_703 particle) {
        this.data = data;
        class_243 axis = data.rotationAxis().method_1027() < 1.0E-4 ? new class_243(0.0, 1.0, 0.0) : data.rotationAxis().method_1029();
        Vector3d offset = new Vector3d(-axis.method_10214(), axis.method_10216(), 0.0).normalize();
        this.initOffX = offset.x();
        this.initOffY = offset.y();
        this.radius = data.radius();
        this.angle = data.angle() * ((float)Math.PI / 180);
        this.centerX = ((ParticleAccessor)particle).getX();
        this.centerY = ((ParticleAccessor)particle).getY();
        this.centerZ = ((ParticleAccessor)particle).getZ();
        this.last = new Vector3d(this.centerX, this.centerY, this.centerZ);
        this.moveParticle(particle);
    }

    @Override
    public void tick(class_703 particle) {
        if (this.data.radiusIncrease() == 0.0f && this.data.angleIncrease() == 0.0f) {
            return;
        }
        this.moveParticle(particle);
    }

    protected void moveParticle(class_703 particle) {
        Vector3d offset = new Vector3d(this.initOffX * this.radius, this.initOffY * this.radius, 0.0);
        offset.rotateAxis(this.angle, this.data.rotationAxis().method_10216(), this.data.rotationAxis().method_10214(), this.data.rotationAxis().method_10215());
        double dX = ((ParticleAccessor)particle).getX() - this.last.x();
        double dY = ((ParticleAccessor)particle).getY() - this.last.y();
        double dZ = ((ParticleAccessor)particle).getZ() - this.last.z();
        this.centerX += dX;
        this.centerY += dY;
        this.centerZ += dZ;
        offset.add(this.centerX, this.centerY, this.centerZ);
        particle.method_3063(offset.x(), offset.y(), offset.z());
        this.angle += (double)(this.data.angleIncrease() * ((float)Math.PI / 180));
        this.radius += (double)this.data.radiusIncrease();
        this.last = offset;
    }
}

