/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.common.data.SyncableReloadListener;
import io.github.flemmli97.tenshilib.common.data.SyncedReloadListeners;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.DefaultedAnimationContainer;
import io.github.flemmli97.tenshilib.common.network.S2CAnimationDataPacket;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class AnimationDataManager
extends class_4309
implements SyncableReloadListener {
    public static final class_2960 ID = class_2960.method_60655((String)"tenshilib", (String)"animation_definitions");
    public static final String DIRECTORY = String.format("%s/%s", ID.method_12836(), ID.method_12832());
    private static final AnimationDataManager INSTANCE = AnimationDataManager.createInstance();
    private Map<class_2960, AnimationDefinitionContainer> animations = new HashMap<class_2960, AnimationDefinitionContainer>();

    private AnimationDataManager() {
        super(new Gson(), DIRECTORY);
    }

    private static AnimationDataManager createInstance() {
        AnimationDataManager inst = new AnimationDataManager();
        SyncedReloadListeners.addOrUpdate(ID, inst);
        return inst;
    }

    public static AnimationDataManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void onSync(Collection<class_3222> players) {
        LoaderNetwork.INSTANCE.sendToAll((class_8710)new S2CAnimationDataPacket(this.animations), players);
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        object.forEach((res, json) -> {
            try {
                builder.put(res, (Object)((AnimationsBuilder)AnimationsBuilder.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow()).build());
            }
            catch (Exception e) {
                TenshiLib.LOGGER.error("Unable to parse animation file {}", res, (Object)e);
            }
        });
        this.animations = builder.build();
    }

    public AnimationDefinitionContainer getAnimation(class_1299<?> type, AnimationDefinitionContainer defaulted) {
        return this.getAnimation(class_7923.field_41177.method_10221(type), defaulted);
    }

    @Nullable
    public AnimationDefinitionContainer getAnimation(class_2960 res, AnimationDefinitionContainer defaulted) {
        AnimationDefinitionContainer container = this.getAnimation(res);
        if (container == null) {
            return defaulted;
        }
        return new DefaultedAnimationContainer(defaulted, container);
    }

    public AnimationDefinitionContainer getAnimation(class_1299<?> type) {
        return this.getAnimation(class_7923.field_41177.method_10221(type));
    }

    @Nullable
    public AnimationDefinitionContainer getAnimation(class_2960 res) {
        return this.animations.get(res);
    }

    public void updateFrom(S2CAnimationDataPacket pkt) {
        this.animations = Map.copyOf(pkt.content());
    }
}

