/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    @Nullable
    public static <T extends class_1297> T findFromUUID(Class<T> clss, class_1937 level, UUID uuid) {
        return (T)EntityUtils.findFromUUID(clss, level, uuid, t -> true);
    }

    @Nullable
    public static <T extends class_1297> T findFromUUID(Class<T> clss, class_1937 level, UUID uuid, Predicate<T> pred) {
        if (level instanceof class_3218) {
            class_1297 e = ((class_3218)level).method_14190(uuid);
            if (e != null && clss.isAssignableFrom(e.getClass()) && pred.test(e)) {
                return (T)e;
            }
        } else {
            for (class_1297 e : ((class_638)level).method_18112()) {
                if (!e.method_5667().equals(uuid) || !clss.isAssignableFrom(e.getClass()) || !pred.test(e)) continue;
                return (T)e;
            }
        }
        return null;
    }

    public static class_1799 findItem(class_1657 player, Predicate<class_1799> pred, boolean searchArmor, boolean offHand) {
        for (class_1799 stack : player.method_31548().field_7547) {
            if (!pred.test(stack)) continue;
            return stack;
        }
        if (searchArmor) {
            for (class_1799 stack : player.method_31548().field_7548) {
                if (!pred.test(stack)) continue;
                return stack;
            }
        }
        if (offHand) {
            for (class_1799 stack : player.method_31548().field_7544) {
                if (!pred.test(stack)) continue;
                return stack;
            }
        }
        return class_1799.field_8037;
    }

    public static class_243 getStraightProjectileTarget(class_243 from, class_1297 target) {
        class_238 aabb = target.method_5829();
        return EntityUtils.getStraightProjectileTarget(from, target.method_19538(), aabb.field_1322 + (double)target.method_17682() * 0.15, aabb.field_1325 - (double)target.method_17682() * 0.15);
    }

    public static class_243 getStraightProjectileTarget(class_243 from, class_243 target, double minY, double maxY) {
        return new class_243(target.method_10216(), class_3532.method_15350((double)from.method_10214(), (double)minY, (double)maxY), target.method_10215());
    }

    @Nullable
    public static class_2338 randomPosAround(class_1937 level, class_1297 entity, class_2338 pos, int range, boolean grounded, Random rand) {
        int randX = pos.method_10263() + rand.nextInt(2 * range) - range;
        int randY = pos.method_10264() + rand.nextInt(2 * range) - range;
        int randZ = pos.method_10260() + rand.nextInt(2 * range) - range;
        if (!grounded) {
            class_2338 pos1 = new class_2338(randX, randY, randZ);
            while (Math.abs(randY - pos1.method_10264()) < range && !level.method_18026(entity.method_5829().method_996(pos1))) {
                pos1 = pos1.method_10084();
            }
            if (!level.method_18026(entity.method_5829().method_996(pos1))) {
                return null;
            }
            return pos1;
        }
        int y = pos.method_10264() - range;
        class_2338 pos1 = new class_2338(randX, y, randZ);
        while (!(pos1.method_10264() - y >= range || level.method_8320(pos1.method_10074()).method_26169((class_1922)level, pos1.method_10074(), entity, class_2350.field_11036) && level.method_18026(entity.method_5829().method_996(pos1)))) {
            pos1 = pos1.method_10084();
        }
        if (!level.method_18026(entity.method_5829().method_996(pos1))) {
            return null;
        }
        return pos1;
    }
}

