/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5569;
import net.minecraft.class_6025;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class MultiPartEntity
extends class_1297
implements class_6025 {
    protected static final class_2940<Optional<UUID>> PARENT_UUID = class_2945.method_12791(MultiPartEntity.class, (class_2941)class_2943.field_13313);
    protected static final class_2940<Float> SIZE_X = class_2945.method_12791(MultiPartEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Float> SIZE_Y = class_2945.method_12791(MultiPartEntity.class, (class_2941)class_2943.field_13320);
    private class_1309 parent;
    private boolean addedToLevel;
    private boolean isHead;
    private MultipartPosition relativePosition = MultipartPosition.DEFAULT;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;

    public MultiPartEntity(class_1299<? extends MultiPartEntity> multipartType, class_1937 level) {
        super(multipartType, level);
    }

    public MultiPartEntity(class_1299<? extends MultiPartEntity> multipartType, class_1309 parent, float width, float height) {
        this(multipartType, parent.method_37908());
        this.setSize(width, height);
        this.setParent(parent);
    }

    public void setParent(class_1309 parent) {
        this.field_6011.method_12778(PARENT_UUID, Optional.of(parent.method_5667()));
        this.parent = parent;
    }

    public MultiPartEntity setHeadPart() {
        this.isHead = true;
        return this;
    }

    public MultiPartEntity setSizeX(float x) {
        this.setSize(x, ((Float)this.field_6011.method_12789(SIZE_Y)).floatValue());
        return this;
    }

    public MultiPartEntity setSizeY(float y) {
        this.setSize(((Float)this.field_6011.method_12789(SIZE_X)).floatValue(), y);
        return this;
    }

    public MultiPartEntity setSize(float x, float y) {
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(SIZE_X, (Object)Float.valueOf(x));
            this.field_6011.method_12778(SIZE_Y, (Object)Float.valueOf(y));
        }
        this.method_18382();
        return this;
    }

    public MultiPartEntity updatePosition(class_243 relativePosition) {
        return this.updatePosition(new MultipartPosition(relativePosition));
    }

    public MultiPartEntity updatePosition(MultipartPosition relativePosition) {
        this.relativePosition = relativePosition;
        return this;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(PARENT_UUID, Optional.empty());
        builder.method_56912(SIZE_X, (Object)Float.valueOf(0.0f));
        builder.method_56912(SIZE_Y, (Object)Float.valueOf(0.0f));
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (SIZE_Y.equals(key)) {
            this.setSize(((Float)this.field_6011.method_12789(SIZE_X)).floatValue(), ((Float)this.field_6011.method_12789(SIZE_Y)).floatValue());
        }
    }

    protected MultipartPosition relativePosition() {
        return this.relativePosition;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.getDefaultDimensions().method_18383(this.method_35057() != null ? this.method_35057().method_55693() : 1.0f);
    }

    protected class_4048 getDefaultDimensions() {
        float ageScale = this.method_35057() != null ? this.method_35057().method_17825() : 1.0f;
        return class_4048.method_18384((float)(ageScale * ((Float)this.field_6011.method_12789(SIZE_X)).floatValue()), (float)(ageScale * ((Float)this.field_6011.method_12789(SIZE_Y)).floatValue()));
    }

    public class_2561 method_5477() {
        class_1309 owner = this.method_35057();
        return owner != null ? owner.method_5477() : super.method_5477();
    }

    protected void method_5749(class_2487 compound) {
    }

    protected void method_5652(class_2487 compound) {
    }

    public void method_5773() {
        if (!(this.method_37908().field_9236 || this.method_35057() != null && this.method_35057().method_5805())) {
            this.method_5650(class_1297.class_5529.field_26998);
            return;
        }
        super.method_5773();
    }

    public void method_5670() {
        this.method_37908().method_16107().method_15396("entityBaseTick");
        this.method_5772();
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        this.method_5646();
        if (this.method_5771()) {
            this.method_5730();
            this.field_6017 *= 0.5f;
        }
        this.method_31473();
        if (!this.method_37908().field_9236) {
            this.updatePosition();
        }
        this.handleLerp();
        this.field_5953 = false;
        this.method_37908().method_16107().method_15407();
    }

    protected void updatePosition() {
        class_243 newPos = this.method_35057().method_19538().method_1019(this.relativePosition.getPosition(this.method_35057()));
        this.moveTo(newPos.method_10216(), newPos.method_10214(), newPos.method_10215(), this.relativePosition.noPhysics());
    }

    protected void handleLerp() {
        if (this.lerpSteps > 0) {
            this.method_52532(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        }
    }

    public void method_5759(double x, double y, double z, float yRot, float xRot, int steps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = steps;
    }

    public double method_53830() {
        return this.lerpSteps > 0 ? this.lerpX : this.method_23317();
    }

    public double method_53827() {
        return this.lerpSteps > 0 ? this.lerpY : this.method_23318();
    }

    public double method_53828() {
        return this.lerpSteps > 0 ? this.lerpZ : this.method_23321();
    }

    public float method_53829() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.method_36455();
    }

    public float method_53831() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.method_36454();
    }

    protected void moveTo(double x, double y, double z, boolean simple) {
        if (this.method_35057() != null && !this.isEntityAddedToLevel()) {
            this.method_5814(x, y, z);
            this.method_37908().method_8649((class_1297)this);
        }
        class_243 old = this.method_19538();
        this.method_22862();
        if (simple) {
            this.method_5814(x, y, z);
        } else {
            this.method_24830(true);
            double vy = y - old.field_1351;
            if (vy >= 0.0 && vy < 1.5) {
                vy = vy <= 1.0 ? -0.08 : 0.0;
            }
            this.method_5784(class_1313.field_6308, new class_243(x - old.field_1352, vy, z - old.field_1350));
        }
    }

    public boolean parentTick() {
        if (this.method_35057() != null && !this.method_35057().method_37908().field_9236 && !this.isEntityAddedToLevel()) {
            this.method_33574(this.method_35057().method_19538());
            this.method_37908().method_8649((class_1297)this);
            return true;
        }
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        return this.method_35057() != null && this.method_35057().method_5643(source, amount);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        return this.method_35057() != null ? this.method_35057().method_5688(player, hand) : class_1269.field_5811;
    }

    public boolean method_30949(class_1297 entity) {
        return false;
    }

    public boolean method_5679(class_1282 source) {
        if (this.method_35057() != null && this.method_35057().method_5679(source)) {
            return true;
        }
        return source.method_48789(class_8103.field_42250) || source.method_48789(class_8103.field_42251) || !this.isHead && source.method_49708(class_8111.field_42340) || super.method_5679(source);
    }

    public boolean method_5809() {
        return this.method_35057() != null && this.method_35057().method_5809();
    }

    public int method_32312() {
        return this.method_35057() != null ? this.method_35057().method_32312() : 0;
    }

    public boolean method_5863() {
        return this.method_35057() != null;
    }

    public class_1799 method_31480() {
        return this.method_35057() != null ? this.method_35057().method_31480() : null;
    }

    public void method_31744(class_5569 entityInLevelCallback) {
        super.method_31744(entityInLevelCallback);
        this.addedToLevel = true;
    }

    public boolean isEntityAddedToLevel() {
        return this.addedToLevel;
    }

    public boolean method_5740() {
        return true;
    }

    @Nullable
    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(PARENT_UUID)).orElse(null);
    }

    public class_1309 method_35057() {
        if (this.parent != null && this.parent.method_5805()) {
            return this.parent;
        }
        ((Optional)this.field_6011.method_12789(PARENT_UUID)).ifPresent(uuid -> {
            this.parent = EntityUtils.findFromUUID(class_1309.class, this.method_37908(), uuid);
        });
        return this.parent;
    }

    public record MultipartPosition(class_243 relative, PositionUpdater updater, boolean noPhysics) {
        public static final MultipartPosition DEFAULT = new MultipartPosition(class_243.field_1353);

        public MultipartPosition(class_243 relative) {
            this(relative, PositionUpdater.FROM_YROT, true);
        }

        public MultipartPosition(class_243 relative, boolean noPhysics) {
            this(relative, PositionUpdater.FROM_YROT, noPhysics);
        }

        public class_243 getPosition(class_1309 parent) {
            return this.updater().from(this.relative(), parent);
        }
    }

    static interface PositionUpdater {
        public static final PositionUpdater FROM_YROT = (relative, parent) -> relative.method_1024(-parent.field_6283 * ((float)Math.PI / 180));

        public class_243 from(class_243 var1, class_1309 var2);
    }
}

