/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.brain;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.DummyBehaviour;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.PlayAnimation;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetAnimationToPlay;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.SequentialBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;

public class AttackBehaviourBuilder<E extends class_1308> {
    private final List<Pair<ExtendedBehaviour<E>, Integer>> behaviors = new ArrayList<Pair<ExtendedBehaviour<E>, Integer>>();
    private PlayAnimation.AnimationTickHandler<E> universalHandler;
    private Function<E, Integer> universalTimeout = entity -> entity.method_59922().method_43048(20) + 50;

    public static <E extends class_1308> AttackBehaviourBuilder<E> create() {
        return new AttackBehaviourBuilder<E>();
    }

    public AttackBehaviourBuilder<E> universalHandler(PlayAnimation.AnimationTickHandler<E> animationTickHandler) {
        this.universalHandler = animationTickHandler;
        return this;
    }

    public AttackBehaviourBuilder<E> universalTimeout(Function<E, Integer> universalTimeout) {
        this.universalTimeout = universalTimeout;
        return this;
    }

    public SingleAttack start(String ... animations) {
        return this.start(new SetAnimationToPlay(animations));
    }

    @SafeVarargs
    public final SingleAttack start(AnimationPlayHolder<E> ... animations) {
        return this.start(new SetAnimationToPlay<E>(animations));
    }

    public SingleAttack start(SetAnimationToPlay<E> behavior) {
        return new SingleAttack(behavior);
    }

    public ExtendedBehaviour<E> build() {
        return new OneRandomBehaviour((Pair[])this.behaviors.toArray(Pair[]::new));
    }

    public class SingleAttack {
        private final SetAnimationToPlay<E> setToPlay;
        private final List<ExtendedBehaviour<E>> preparations = new ArrayList();
        private Function<E, Integer> windupTime;
        private PlayAnimation<E> actuallyPlay = new PlayAnimation();

        private SingleAttack(SetAnimationToPlay<E> behavior) {
            this.setToPlay = behavior;
        }

        @SafeVarargs
        public final SingleAttack prepare(ExtendedBehaviour<E> ... behaviors) {
            Collections.addAll(this.preparations, behaviors);
            return this;
        }

        @SafeVarargs
        public final SingleAttack prepareOptional(ExtendedBehaviour<E> ... behaviors) {
            for (ExtendedBehaviour behaviour : behaviors) {
                this.preparations.add(DummyBehaviour.opt(behaviour));
            }
            return this;
        }

        public SingleAttack parallel(Function<E, Integer> windupTime) {
            this.windupTime = windupTime;
            return this;
        }

        public SingleAttack play(PlayAnimation<E> actuallyPlay) {
            this.actuallyPlay = actuallyPlay;
            return this;
        }

        public SingleAttack condition(Predicate<E> condition) {
            this.setToPlay.startCondition(condition);
            return this;
        }

        public AttackBehaviourBuilder<E> end() {
            return this.end(1);
        }

        public AttackBehaviourBuilder<E> end(int weight) {
            return this.end(weight, null);
        }

        public AttackBehaviourBuilder<E> end(int weight, Consumer<ExtendedBehaviour<E>> finalize) {
            ArrayList behaviours = new ArrayList();
            behaviours.add(this.setToPlay);
            PlayAnimation actuallyPlay = this.actuallyPlay.replaceRunner(AttackBehaviourBuilder.this.universalHandler);
            if (this.windupTime != null) {
                ExtendedBehaviour preparation = this.seqOf(this.preparations);
                SequentialBehaviour attack = new SequentialBehaviour(new ExtendedBehaviour[]{new Idle().runFor(this.windupTime), actuallyPlay});
                behaviours.add((ExtendedBehaviour)new AllApplicableBehaviours(new ExtendedBehaviour[]{preparation, attack}));
            } else {
                behaviours.addAll(this.preparations);
                behaviours.add(actuallyPlay);
            }
            SequentialBehaviour attackBehaviour = new SequentialBehaviour((ExtendedBehaviour[])behaviours.toArray(ExtendedBehaviour[]::new));
            if (AttackBehaviourBuilder.this.universalTimeout != null) {
                attackBehaviour.runFor(AttackBehaviourBuilder.this.universalTimeout);
            }
            if (finalize != null) {
                finalize.accept((ExtendedBehaviour)attackBehaviour);
            }
            AttackBehaviourBuilder.this.behaviors.add(new Pair((Object)attackBehaviour, (Object)weight));
            return AttackBehaviourBuilder.this;
        }

        private ExtendedBehaviour<E> seqOf(List<ExtendedBehaviour<E>> list) {
            if (list.isEmpty()) {
                return new Idle().runFor(e -> 1);
            }
            if (list.size() == 1) {
                return list.getFirst();
            }
            return new SequentialBehaviour((ExtendedBehaviour[])list.toArray(ExtendedBehaviour[]::new));
        }
    }
}

