/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.effects;

import com.google.common.collect.ImmutableList;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.effects.ParticleEffect;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffectConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PatreonEffects {
    private static final Map<String, PatreonEffectConfig> CONFIGS = new HashMap<String, PatreonEffectConfig>();
    private static final List<PatreonEffectConfig> EFFECTS = new ArrayList<PatreonEffectConfig>();
    public static final PatreonEffectConfig MEGU_HAT = PatreonEffects.register(new PatreonEffectConfig("megu_hat", 2){

        @Override
        public boolean locationAllowed(RenderLocation loc) {
            return RenderLocation.isHead(loc) || RenderLocation.isCircling(loc);
        }

        @Override
        public RenderLocation defaultLoc() {
            return RenderLocation.HAT;
        }
    });
    public static final PatreonEffectConfig CHOMUSUKE = PatreonEffects.register(new PatreonEffectConfig("chomusuke", 2){

        @Override
        public boolean locationAllowed(RenderLocation loc) {
            return loc != RenderLocation.BACK;
        }

        @Override
        public RenderLocation defaultLoc() {
            return RenderLocation.CIRCLING;
        }
    });
    public static final PatreonEffectConfig CAT = PatreonEffects.register(new PatreonEffectConfig("cat", 3){

        @Override
        public boolean locationAllowed(RenderLocation loc) {
            return loc != RenderLocation.BACK;
        }

        @Override
        public RenderLocation defaultLoc() {
            return RenderLocation.CIRCLING;
        }
    });
    public static final PatreonEffectConfig HALO = PatreonEffects.register(new PatreonEffectConfig("halo", 2){

        @Override
        public boolean locationAllowed(RenderLocation loc) {
            return RenderLocation.isHead(loc);
        }

        @Override
        public RenderLocation defaultLoc() {
            return RenderLocation.HAT;
        }
    });
    public static final PatreonEffectConfig HALO_PARTICLE = PatreonEffects.register(ParticleEffect.Builder.of().add(new ParticleEffect.Pattern(class_2350.class_2351.field_11052, new class_243(-0.3, 0.0, -0.3)).setSpacing(0.12).addParticlePos('p', (class_2394)new class_2390(new Vector3f((Vector3fc)class_243.method_24457((int)15461736).method_46409()), 0.7f), (p, i) -> class_243.field_1353.method_1031(0.0, (double)p.method_17682() + 0.2, 0.0)).addPattern(" pppp ", "pp  pp", "p    p", "p    p", "pp  pp", " pppp ")).build("halo_particle", 1));
    public static final PatreonEffectConfig CLOUD_PARTICLE = PatreonEffects.register(ParticleEffect.Builder.of().add(new ParticleEffect.Pattern(class_2350.class_2351.field_11052, new class_243(-0.705, 0.1, -0.705)).setSpacing(0.47).addParticle('p', (class_2394)class_2398.field_11204).addPattern(" pp ", "pppp", "pppp", " pp ")).build("cloud_particle", 1));
    public static final PatreonEffectConfig ENCHANTED_PARTICLE = PatreonEffects.register(ParticleEffect.Builder.of().add(new ParticleEffect.Pattern(class_2350.class_2351.field_11048, new class_243(0.0, 0.0, 0.0)).setSpacing(0.1).addParticle('p', (class_2394)class_2398.field_11215, (p, i) -> ParticleEffect.Pattern.randomAll(0.7).apply(p).method_1031(0.0, (double)p.method_17682() * 0.5 - 0.1, 0.0), (p, i) -> ParticleEffect.Pattern.randomAll(0.3).apply(p)).addPattern("p", "p", "p")).add(new ParticleEffect.Pattern(class_2350.class_2351.field_11048, new class_243(0.0, 0.0, 0.0)).setSpacing(0.1).addParticle('p', (class_2394)class_2398.field_11215, (p, i) -> ParticleEffect.Pattern.randomAll(0.7).apply(p).method_1031(0.0, (double)p.method_17682() * 0.5 - 0.1, 0.0), (p, i) -> ParticleEffect.Pattern.randomAll(0.3).apply(p)).addPattern("p", "p", "p")).build("enchanted", 1));
    public static final PatreonEffectConfig FLAMING_SHIELD = PatreonEffects.register(ParticleEffect.Builder.of().add(new ParticleEffect.Pattern(class_2350.class_2351.field_11048, new class_243(0.0, 0.0, 0.0)).setSpacing(0.0).addParticlePos('p', (class_2394)class_2398.field_11240, (p, i) -> {
        float tick = p.field_6012;
        double height = (double)p.method_17682() * 0.5;
        float offset = (float)i * (float)Math.PI / 2.0f;
        return new class_243((double)class_3532.method_15362((float)((float)Math.PI / 180 * tick * 5.0f + offset)), (double)class_3532.method_15374((float)((float)Math.PI / 180 * tick * 2.0f * (float)(i > 3 ? -1 : 1))) * height + height, (double)class_3532.method_15374((float)((float)Math.PI / 180 * tick * 5.0f + offset)));
    }).addPattern("pppppppp")).build("flaming_shield", 1));

    private static <T extends PatreonEffectConfig> T register(T conf) {
        CONFIGS.put(conf.id(), conf);
        EFFECTS.add(conf);
        return conf;
    }

    public static PatreonEffectConfig get(String id) {
        return CONFIGS.get(id);
    }

    public static List<PatreonEffectConfig> allEffects() {
        return ImmutableList.copyOf(EFFECTS);
    }
}

