/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui.widget.list;

import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableEntry;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableListWidget;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;

public class SelectableText
implements SelectableEntry {
    private final Component text;
    private int paddingX = 4;
    private SelectButton[] button;
    private WidgetSprites entryTexture;
    private boolean selectable = true;
    private FormattedCharSequence sequence;
    private FormattedCharSequence blankSequence;
    private int lastWidth;
    private int width;
    private int height;

    public SelectableText(String text, ChatFormatting ... chatFormattings) {
        this((Component)Component.translatable((String)text).withStyle(chatFormattings));
    }

    public SelectableText(Component text) {
        this.text = text;
    }

    public SelectableText padding(int padding) {
        this.paddingX = padding;
        return this;
    }

    public SelectableText with(SelectButton ... clickHandler) {
        return this.with(false, clickHandler);
    }

    public SelectableText with(boolean canSelect, SelectButton ... clickHandler) {
        this.selectable = canSelect;
        this.button = clickHandler;
        return this;
    }

    public SelectableText withTexture(WidgetSprites entryTexture) {
        this.entryTexture = entryTexture;
        return this;
    }

    public SelectableText noSelect() {
        this.selectable = false;
        return this;
    }

    @Override
    public void updateDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(SelectableListWidget widget, GuiGraphics graphics, int mouseX, int mouseY, float partialTick, int x, int y, boolean selected, boolean hovered) {
        if (this.entryTexture != null) {
            graphics.blitSprite(this.entryTexture.get(true, hovered), x, y, this.width, this.height);
        } else if (selected || hovered) {
            graphics.fill(x, y, x + this.width, y + this.height, -1609560048);
        }
        int textWidth = this.width - this.paddingX;
        if (this.getButtons() != null && this.getButtons().length > 0) {
            int skipped = 0;
            for (int idx = 0; idx < this.getButtons().length; ++idx) {
                SelectButton btn = this.getButtons()[this.getButtons().length - 1 - idx];
                if (!btn.shouldRender().getAsBoolean()) {
                    ++skipped;
                    continue;
                }
                int[] xY = this.getButtonStart(idx - skipped);
                int bX = xY[0] + x;
                int bY = xY[1] + y;
                textWidth = xY[0] - 2;
                boolean over = mouseX >= bX && mouseY >= bY && mouseX < bX + 12 && mouseY < bY + 12;
                graphics.blitSprite(btn.texture().get(true, over), bX, bY, 12, 12);
            }
        }
        graphics.drawString(widget.getFont(), this.getText(widget.getFont(), textWidth - this.paddingX, selected || hovered), x + this.paddingX, y + (int)(0.5 * (double)this.height - 3.5), selected ? ChatFormatting.LIGHT_PURPLE.getColor() : (hovered ? ChatFormatting.YELLOW.getColor() : 0xFFFFFF));
    }

    @Override
    public boolean onClick(double relativeMouseX, double relativeMouseY, boolean selected) {
        if (this.getButtons() != null && this.getButtons().length > 0) {
            int skipped = 0;
            for (int idx = 0; idx < this.getButtons().length; ++idx) {
                int[] xY;
                boolean over;
                SelectButton btn = this.getButtons()[this.getButtons().length - 1 - idx];
                if (!btn.shouldRender().getAsBoolean()) {
                    ++skipped;
                }
                boolean bl = over = relativeMouseX >= (double)(xY = this.getButtonStart(idx - skipped))[0] && relativeMouseY >= (double)xY[1] && relativeMouseX < (double)(xY[0] + 12) && relativeMouseY < (double)(xY[1] + 12);
                if (!over) continue;
                btn.onClick().run();
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return false;
            }
        }
        return this.selectable;
    }

    public FormattedCharSequence getText(Font font, int width, boolean highlight) {
        if (this.sequence == null || this.lastWidth != width) {
            this.sequence = SelectableEntry.dottedWith(font, this.text, width, false);
            this.blankSequence = SelectableEntry.dottedWith(font, this.text, width, true);
            this.lastWidth = width;
        }
        return highlight ? this.blankSequence : this.sequence;
    }

    public SelectButton[] getButtons() {
        return this.button;
    }

    private int[] getButtonStart(int position) {
        int btnX = this.width - this.paddingX - 12 - position * 14;
        int btnY = (int)(0.5 * (double)this.height) - 6;
        return new int[]{btnX, btnY};
    }

    public record SelectButton(WidgetSprites texture, Runnable onClick, BooleanSupplier shouldRender) {
        private static final BooleanSupplier ALWAYS = () -> true;

        public SelectButton(WidgetSprites texture, Runnable onClick) {
            this(texture, onClick, ALWAYS);
        }
    }
}

