/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public abstract class ItemProjectileRenderer<T extends Entity>
extends EntityRenderer<T> {
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;
    protected float scaleZ = 1.0f;

    public ItemProjectileRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(T entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        stack.scale(this.scaleX, this.scaleY, this.scaleZ);
        stack.translate(0.0, 0.15, 0.0);
        switch (this.getRenderType(entity).ordinal()) {
            case 0: {
                stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case 1: {
                stack.mulPose(Axis.YP.rotationDegrees(90.0f + Mth.lerp((float)partialTicks, (float)((Entity)entity).yRotO, (float)entity.getYRot())));
                stack.mulPose(Axis.ZP.rotationDegrees(135.0f - Mth.lerp((float)partialTicks, (float)((Entity)entity).xRotO, (float)entity.getXRot())));
            }
        }
        Minecraft.getInstance().getItemRenderer().renderStatic(this.getRenderItemStack(entity), ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, stack, buffer, entity.level(), entity.getId());
        stack.popPose();
        super.render(entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }

    public abstract ItemStack getRenderItemStack(T var1);

    public abstract Type getRenderType(T var1);

    public static enum Type {
        NORMAL,
        WEAPON;

    }
}

