/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ModelRenderLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    protected final EntityModel<T> model;
    protected final LivingEntityRenderer<T, M> renderer;
    protected final ResourceLocation texture;

    public ModelRenderLayer(LivingEntityRenderer<T, M> renderer, EntityModel<T> model, ResourceLocation texture) {
        super(renderer);
        this.model = model;
        this.renderer = renderer;
        this.texture = texture;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isInvisible()) {
            return;
        }
        poseStack.pushPose();
        if (this.getParentModel().young) {
            poseStack.translate(0.0f, 0.75f, 0.0f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
        }
        if (entity.isShiftKeyDown()) {
            poseStack.translate(0.0f, 0.2f, 0.0f);
        }
        this.model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        Minecraft mc = Minecraft.getInstance();
        boolean flag = !entity.isInvisible();
        boolean flag1 = !flag && !entity.isInvisibleTo((Player)mc.player);
        boolean flag2 = mc.shouldEntityAppearGlowing(entity);
        RenderType rendertype = this.getRenderType(entity, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer ivertexbuilder = buffer.getBuffer(rendertype);
            int i = LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f);
            this.model.renderToBuffer(poseStack, ivertexbuilder, packedLightIn, i, FastColor.ARGB32.colorFromFloat((float)(flag1 ? 0.15f : 1.0f), (float)1.0f, (float)1.0f, (float)1.0f));
        }
        poseStack.popPose();
    }

    protected RenderType getRenderType(T entity, boolean invis, boolean canSee, boolean glowing) {
        ResourceLocation resourcelocation = this.texture;
        if (canSee) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourcelocation);
        }
        if (invis) {
            return this.model.renderType(resourcelocation);
        }
        return glowing ? RenderType.outline((ResourceLocation)resourcelocation) : null;
    }
}

