/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.attachment;

import io.github.flemmli97.tenshilib.common.attachment.AttachmentTransferHandler;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class AttachmentType<T> {
    private final Function<Object, T> defaultValueSupplier;
    @Nullable
    private final AttachmentTransferHandler<T> transferHandler;

    private AttachmentType(Function<Object, T> defaultValueSupplier, @Nullable AttachmentTransferHandler<T> transferHandler) {
        this.defaultValueSupplier = defaultValueSupplier;
        this.transferHandler = transferHandler;
    }

    public static <T> Builder<T> builder(Supplier<T> defaultValueSupplier) {
        return AttachmentType.builder((Object v) -> defaultValueSupplier.get());
    }

    public static <T> Builder<T> builder(Function<Object, T> defaultValueSupplier) {
        return new Builder<T>(defaultValueSupplier);
    }

    protected AttachmentType(AttachmentType<T> of) {
        this(of.defaultValueSupplier, of.transferHandler);
    }

    public Function<Object, T> defaultValueSupplier() {
        return this.defaultValueSupplier;
    }

    public Optional<AttachmentTransferHandler<T>> transferHandler() {
        return Optional.ofNullable(this.transferHandler);
    }

    public static class Builder<T> {
        private final Function<Object, T> defaultValueSupplier;
        @Nullable
        private AttachmentTransferHandler<T> transferHandler;

        private Builder(Function<Object, T> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
        }

        public Builder<T> transferHandler(@Nullable AttachmentTransferHandler<T> transferHandler) {
            this.transferHandler = transferHandler;
            return this;
        }

        public AttachmentType<T> build() {
            return new AttachmentType<T>(this.defaultValueSupplier, this.transferHandler);
        }
    }
}

