/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.item;

import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.network.S2CAnimationScreen;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AnimationDebugger
extends Item {
    private final Supplier<DataComponentType<UUID>> entityIDType;
    private final Supplier<DataComponentType<String>> animationIdx;

    public AnimationDebugger(Item.Properties props, Supplier<DataComponentType<UUID>> entityIDType, Supplier<DataComponentType<String>> animationIdx) {
        super(props);
        this.entityIDType = entityIDType;
        this.animationIdx = animationIdx;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand usedHand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (entity instanceof AnimatedEntity) {
                stack.set(this.entityIDType.get(), (Object)entity.getUUID());
                stack.remove(this.animationIdx.get());
                player.setItemInHand(usedHand, stack);
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"tenshilib.item.animation.select", (Object[])new Object[]{entity.getName()}).withStyle(ChatFormatting.AQUA), true);
            }
        }
        return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!(player instanceof ServerPlayer)) return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)player.level().isClientSide);
        ServerPlayer serverPlayer = (ServerPlayer)player;
        UUID uuid = (UUID)stack.get(this.entityIDType.get());
        if (uuid == null) return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)player.level().isClientSide);
        Mob storedEntity = EntityUtils.findFromUUID(Mob.class, player.level(), uuid);
        if (storedEntity instanceof AnimatedEntity) {
            AnimatedEntity animated = (AnimatedEntity)storedEntity;
            if (storedEntity.isAlive()) {
                if (player.isShiftKeyDown()) {
                    LoaderNetwork.INSTANCE.sendToPlayer(new S2CAnimationScreen(usedHand, (LivingEntity)((Mob)animated)), serverPlayer);
                    return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)player.level().isClientSide);
                }
                String id = this.getId(stack);
                if (id.isEmpty()) return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)player.level().isClientSide);
                animated.getAnimationHandler().setAnimation(id);
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)player.level().isClientSide);
            }
        }
        stack.remove(this.entityIDType.get());
        stack.remove(this.animationIdx.get());
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)player.level().isClientSide);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void updateId(ItemStack stack, String id) {
        stack.set(this.animationIdx.get(), (Object)id);
    }

    public String getId(ItemStack stack) {
        return (String)stack.getOrDefault(this.animationIdx.get(), (Object)"");
    }
}

