/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.network;

import io.github.flemmli97.tenshilib.common.item.AnimationDebugger;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class C2SAnimationDebuggerUpdate
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<C2SAnimationDebuggerUpdate> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tenshilib", (String)"c2s_animation_debugger_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, C2SAnimationDebuggerUpdate> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, C2SAnimationDebuggerUpdate>(){

        public C2SAnimationDebuggerUpdate decode(RegistryFriendlyByteBuf buf) {
            return new C2SAnimationDebuggerUpdate((InteractionHand)buf.readEnum(InteractionHand.class), buf.readUtf());
        }

        public void encode(RegistryFriendlyByteBuf buf, C2SAnimationDebuggerUpdate pkt) {
            buf.writeEnum((Enum)pkt.hand);
            buf.writeUtf(pkt.id);
        }
    };
    private final InteractionHand hand;
    private final String id;

    public C2SAnimationDebuggerUpdate(InteractionHand hand, String id) {
        this.hand = hand;
        this.id = id;
    }

    public static void handle(C2SAnimationDebuggerUpdate pkt, ServerPlayer sender) {
        ItemStack stack = sender.getItemInHand(pkt.hand);
        Item item = stack.getItem();
        if (item instanceof AnimationDebugger) {
            AnimationDebugger debug = (AnimationDebugger)item;
            debug.updateId(stack, pkt.id);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

