/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.network;

import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedMobDataHandler;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class S2CSyncedMobData
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<S2CSyncedMobData> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tenshilib", (String)"s2c_synced_mob_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CSyncedMobData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, S2CSyncedMobData>(){

        public S2CSyncedMobData decode(RegistryFriendlyByteBuf buf) {
            int entity = buf.readInt();
            int size = VarInt.read((ByteBuf)buf);
            ArrayList list = new ArrayList();
            for (int i = 0; i < size; ++i) {
                list.add(i, SyncedDataContainer.SyncedContainer.from(buf));
            }
            return new S2CSyncedMobData(entity, list);
        }

        public void encode(RegistryFriendlyByteBuf buf, S2CSyncedMobData pkt) {
            buf.writeInt(pkt.entity);
            VarInt.write((ByteBuf)buf, (int)pkt.values.size());
            pkt.values.forEach(cont -> cont.write(buf));
        }
    };
    private final int entity;
    private final List<SyncedDataContainer.SyncedContainer<?>> values;

    private S2CSyncedMobData(int entity, List<SyncedDataContainer.SyncedContainer<?>> values) {
        this.entity = entity;
        this.values = values;
    }

    public static <T extends Entity> void send(T entity, List<SyncedDataContainer.SyncedContainer<?>> data) {
        if (!entity.level().isClientSide && !data.isEmpty()) {
            LoaderNetwork.INSTANCE.sendToTracking(new S2CSyncedMobData(entity.getId(), data), entity);
        }
    }

    public static <T extends Entity> void sendTo(T entity, List<SyncedDataContainer.SyncedContainer<?>> data, ServerPlayer player) {
        if (!entity.level().isClientSide && !data.isEmpty()) {
            LoaderNetwork.INSTANCE.sendToPlayer(new S2CSyncedMobData(entity.getId(), data), player);
        }
    }

    public static void handle(S2CSyncedMobData pkt, Player player) {
        Entity entity = player.level().getEntity(pkt.entity);
        if (entity instanceof SyncedMobDataHandler) {
            SyncedMobDataHandler handler = (SyncedMobDataHandler)entity;
            handler.getDataContainer().update(pkt.values);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

