/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.particle.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.ParticleHandlerType;
import io.github.flemmli97.tenshilib.common.registry.TenshilibParticleHandlerTypes;
import io.github.flemmli97.tenshilib.common.utils.StreamCodecs;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.joml.Vector4f;

public record ColorData(Vector4f start, Optional<Vector4f> end, int duration) implements AdvancedParticleData
{
    public static final MapCodec<ColorData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ExtraCodecs.VECTOR4F.fieldOf("start_color").forGetter(ColorData::start), (App)ExtraCodecs.VECTOR4F.optionalFieldOf("end_color").forGetter(ColorData::end), (App)Codec.INT.fieldOf("duration").forGetter(ColorData::duration)).apply((Applicative)inst, ColorData::new));
    public static final StreamCodec<ByteBuf, ColorData> STREAM_CODEC = StreamCodec.composite(StreamCodecs.VECTOR_4F_STREAM, ColorData::start, (StreamCodec)ByteBufCodecs.optional(StreamCodecs.VECTOR_4F_STREAM), ColorData::end, (StreamCodec)ByteBufCodecs.INT, ColorData::duration, ColorData::new);

    public ColorData(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public ColorData(float r, float g, float b, float a) {
        this(new Vector4f(r, g, b, a), Optional.empty(), 0);
    }

    @Override
    public ParticleHandlerType<?> getType() {
        return (ParticleHandlerType)TenshilibParticleHandlerTypes.COLOR.get();
    }
}

