/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.particle.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.ParticleHandlerType;
import io.github.flemmli97.tenshilib.common.registry.TenshilibParticleHandlerTypes;
import io.github.flemmli97.tenshilib.common.utils.StreamCodecs;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public record EntityFollowData(int entity, Optional<Vec3> offset, boolean differenceOnly) implements AdvancedParticleData
{
    public static final MapCodec<EntityFollowData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("entity").forGetter(EntityFollowData::entity), (App)Vec3.CODEC.optionalFieldOf("offset").forGetter(EntityFollowData::offset), (App)Codec.BOOL.fieldOf("difference_only").forGetter(EntityFollowData::differenceOnly)).apply((Applicative)inst, EntityFollowData::new));
    public static final StreamCodec<ByteBuf, EntityFollowData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, EntityFollowData::entity, (StreamCodec)ByteBufCodecs.optional(StreamCodecs.VEC3), EntityFollowData::offset, (StreamCodec)ByteBufCodecs.BOOL, EntityFollowData::differenceOnly, EntityFollowData::new);

    public EntityFollowData(Entity entity) {
        this(entity.getId(), Optional.empty(), false);
    }

    public EntityFollowData(Entity entity, Vec3 offset) {
        this(entity.getId(), Optional.of(offset), false);
    }

    public EntityFollowData(Entity entity, boolean differenceOnly) {
        this(entity.getId(), Optional.empty(), differenceOnly);
    }

    @Override
    public ParticleHandlerType<?> getType() {
        return (ParticleHandlerType)TenshilibParticleHandlerTypes.ENTITY_FOLLOW.get();
    }
}

