/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators;

import io.github.flemmli97.tenshilib.common.utils.math.parser.ExpValue;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.Addition;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.Division;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.Modulo;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.Multiplication;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.Power;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.Substraction;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.logic.And;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.logic.Condition;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.logic.Equals;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.logic.Greater;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.logic.GreaterThan;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.logic.Less;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.logic.LessThan;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.logic.NotEquals;
import io.github.flemmli97.tenshilib.common.utils.math.parser.impl.operators.logic.Or;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class Operators {
    private static final Map<String, Consumer<Stack<ExpValue>>> OPERATORS = Operators.init();

    private static Map<String, Consumer<Stack<ExpValue>>> init() {
        HashMap<String, Consumer<Stack<ExpValue>>> builtin = new HashMap<String, Consumer<Stack<ExpValue>>>();
        builtin.put("+", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new Addition(first, sec));
        });
        builtin.put("-", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new Substraction(first, sec));
        });
        builtin.put("*", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new Multiplication(first, sec));
        });
        builtin.put("/", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new Division(first, sec));
        });
        builtin.put("^", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new Power(first, sec));
        });
        builtin.put("%", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new Modulo(first, sec));
        });
        builtin.put("==", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new Equals(first, sec));
        });
        builtin.put("!=", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new NotEquals(first, sec));
        });
        builtin.put("<", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new Less(first, sec));
        });
        builtin.put("<=", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new LessThan(first, sec));
        });
        builtin.put(">", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new Greater(first, sec));
        });
        builtin.put(">=", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new GreaterThan(first, sec));
        });
        builtin.put("&&", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new And(first, sec));
        });
        builtin.put("||", vars -> {
            ExpValue sec = (ExpValue)vars.pop();
            ExpValue first = (ExpValue)vars.pop();
            vars.push(new Or(first, sec));
        });
        builtin.put("?:", vars -> {
            ExpValue then = (ExpValue)vars.pop();
            ExpValue condition = (ExpValue)vars.pop();
            vars.push(new Condition(condition, then));
        });
        return builtin;
    }

    public static String regex() {
        ArrayList<CallSite> patterns = new ArrayList<CallSite>();
        List sort = OPERATORS.keySet().stream().sorted((f, s) -> Integer.compare(s.length(), f.length())).toList();
        for (String op : sort) {
            patterns.add((CallSite)((Object)("(?:" + Pattern.quote(op) + ")")));
        }
        return String.join((CharSequence)"|", patterns);
    }

    public static void get(String identifier, Stack<ExpValue> stack) {
        Consumer<Stack<ExpValue>> consumer = OPERATORS.get(identifier);
        if (consumer == null) {
            return;
        }
        try {
            consumer.accept(stack);
        }
        catch (EmptyStackException e) {
            System.out.println("Mismatched operator args");
        }
    }
}

