/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.loader;

import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.common.entity.BeamEntity;
import io.github.flemmli97.tenshilib.loader.LoaderInitializer;
import java.util.function.BiPredicate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public interface TenshiLibCrossPlat {
    public static final TenshiLibCrossPlat INSTANCE = LoaderInitializer.getImplInstance(TenshiLibCrossPlat.class, "io.github.flemmli97.tenshilib.fabric.loader.TenshiLibCrossPlatImpl", "io.github.flemmli97.tenshilib.neoforge.loader.TenshiLibCrossPlatImpl");

    public boolean isDatagen();

    public boolean isPhysicalClient();

    public boolean isModLoaded(String var1);

    @Nullable
    public MinecraftServer getCurrentServer();

    @Nullable
    default public Entity getMultipartParent(Entity entity) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            if (entity.getType().is(TenshiLib.MULTIPART_ENTITY)) {
                return ownable.getOwner();
            }
        }
        if (entity instanceof TraceableEntity) {
            TraceableEntity traceableEntity = (TraceableEntity)entity;
            if (entity.getType().is(TenshiLib.MULTIPART_ENTITY)) {
                return traceableEntity.getOwner();
            }
        }
        if (entity instanceof EnderDragonPart) {
            EnderDragonPart part = (EnderDragonPart)entity;
            return part.parentMob;
        }
        return null;
    }

    default public boolean isSameMultipart(Entity entity, Entity parent) {
        if (parent == null) {
            return false;
        }
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            if (entity.getType().is(TenshiLib.MULTIPART_ENTITY)) {
                return parent.getUUID().equals(ownable.getOwnerUUID());
            }
        }
        if (entity instanceof TraceableEntity) {
            TraceableEntity traceableEntity = (TraceableEntity)entity;
            if (entity.getType().is(TenshiLib.MULTIPART_ENTITY)) {
                return parent == traceableEntity.getOwner();
            }
        }
        if (entity instanceof EnderDragonPart) {
            EnderDragonPart part = (EnderDragonPart)entity;
            return parent == part.parentMob;
        }
        return false;
    }

    public boolean projectileImpactEvent(Projectile var1, HitResult var2);

    public boolean beamHitEvent(BeamEntity var1, HitResult var2);

    public void listenBeamHitEvent(BiPredicate<BeamEntity, HitResult> var1);
}

