/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.neoforge.loader.registry;

import io.github.flemmli97.tenshilib.common.attachment.AttachmentTransferHandler;
import io.github.flemmli97.tenshilib.common.attachment.AttachmentType;
import io.github.flemmli97.tenshilib.common.attachment.SerializableAttachment;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="tenshilib")
public class AttachmentTypeWrapper<T>
extends AttachmentType<T> {
    private static final Set<AttachmentTypeWrapper<?>> NEO_ATTACHMENTS = new HashSet();
    private net.neoforged.neoforge.attachment.AttachmentType<T> neoAttachment;

    public AttachmentTypeWrapper(AttachmentType<T> type) {
        super(type);
    }

    public net.neoforged.neoforge.attachment.AttachmentType<T> getNeoAttachment() {
        if (this.neoAttachment == null) {
            this.neoAttachment = net.neoforged.neoforge.attachment.AttachmentType.builder((T h) -> this.defaultValueSupplier().apply(h)).serialize(new IAttachmentSerializer<Tag, T>(){

                public T read(IAttachmentHolder holder, Tag tag, HolderLookup.Provider provider) {
                    Object value = AttachmentTypeWrapper.this.defaultValueSupplier().apply(holder);
                    if (value instanceof SerializableAttachment) {
                        SerializableAttachment ser = (SerializableAttachment)value;
                        ser.read(tag, provider);
                    }
                    return value;
                }

                @Nullable
                public Tag write(T value, HolderLookup.Provider provider) {
                    if (value instanceof SerializableAttachment) {
                        SerializableAttachment ser = (SerializableAttachment)value;
                        return ser.write(provider);
                    }
                    return null;
                }
            }).copyHandler((object, iAttachmentHolder, arg) -> null).build();
            NEO_ATTACHMENTS.add(this);
        }
        return this.neoAttachment;
    }

    private static void copyAttachments(Entity from, Entity to, boolean wasDeath) {
        for (AttachmentTypeWrapper<?> type : NEO_ATTACHMENTS) {
            AttachmentTransferHandler handler;
            Object data = from.getExistingData(type.getNeoAttachment()).orElse(null);
            if (data == null || (handler = (AttachmentTransferHandler)type.transferHandler().orElse(null)) == null) continue;
            net.neoforged.neoforge.attachment.AttachmentType<?> attachmentType = type.getNeoAttachment();
            Object newAttachment = handler.copy(data, to, wasDeath);
            if (newAttachment == null) continue;
            to.setData(attachmentType, newAttachment);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        AttachmentTypeWrapper.copyAttachments((Entity)event.getOriginal(), (Entity)event.getEntity(), event.isWasDeath());
    }

    @SubscribeEvent
    public static void onLivingConvert(LivingConversionEvent.Post event) {
        AttachmentTypeWrapper.copyAttachments((Entity)event.getEntity(), (Entity)event.getOutcome(), true);
    }
}

