/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.client;

import io.github.flemmli97.tenshilib.client.Color;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import io.github.flemmli97.tenshilib.patreon.PatreonDataManager;
import io.github.flemmli97.tenshilib.patreon.PatreonPlayerSetting;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.TenshiLibPatreonPlatform;
import io.github.flemmli97.tenshilib.patreon.client.HorizontalColorSlider;
import io.github.flemmli97.tenshilib.patreon.effects.GuiElement;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffectConfig;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffects;
import io.github.flemmli97.tenshilib.patreon.pkts.C2SEffectUpdatePkt;
import io.github.flemmli97.tenshilib.patreon.pkts.C2SRequestUpdateClientPkt;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PatreonGui
extends Screen {
    public static final int BLACK = -16777216;
    private final Screen parent;
    private PatreonEffectConfig effect;
    private RenderLocation renderLocation;
    private boolean render = true;
    private int color = -1;
    private EditBox txtField;
    private HorizontalColorSlider red;
    private HorizontalColorSlider green;
    private HorizontalColorSlider blue;
    private HorizontalColorSlider alpha;
    private int tier;
    private PatreonPlayerSetting setting;

    public PatreonGui(Screen screen) {
        super((Component)Component.translatable((String)"tenshilib.patreon.title").withStyle(ChatFormatting.GOLD));
        this.parent = screen;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    protected void init() {
        this.clearWidgets();
        int n = this.tier = this.minecraft.level == null ? -1 : PatreonDataManager.get(this.minecraft.player.getUUID().toString()).tier();
        if (this.tier < 1) {
            MutableComponent name = this.tier == -1 ? Component.translatable((String)"tenshilib.patreon.level.no") : Component.translatable((String)"tenshilib.patreon.back");
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)name, button -> this.minecraft.setScreen(this.parent)).pos(this.width / 2 - 100, this.height / 8 + 192).size(200, 20).build());
            return;
        }
        Component name = CommonComponents.GUI_DONE;
        this.setting = TenshiLibPatreonPlatform.INSTANCE.playerSettings((Player)this.minecraft.player);
        if (this.setting == null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"tenshilib.patreon.save"), button -> LoaderNetwork.INSTANCE.sendToServer(new C2SEffectUpdatePkt(this.effect.id(), this.render, this.renderLocation, this.color))).pos(this.width / 2 - 100, this.height / 8 + 168).size(200, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)name, button -> this.minecraft.setScreen(this.parent)).pos(this.width / 2 - 100, this.height / 8 + 192).size(200, 20).build());
            return;
        }
        int yOffset = 0;
        this.effect = this.setting.effect();
        if (this.effect == null) {
            this.effect = PatreonEffects.get(PatreonDataManager.get(this.minecraft.player.getUUID().toString()).defaultEffect());
        }
        this.renderLocation = this.setting.getRenderLocation();
        if (this.effect != null && !this.effect.locationAllowed(this.renderLocation)) {
            this.renderLocation = this.effect.defaultLoc();
        }
        this.render = this.setting.shouldRender();
        this.color = this.setting.getColor();
        Function<PatreonEffectConfig, Component> idF = eff -> Component.translatable((String)("tenshilib.patreon.id." + eff.id()));
        ArrayList<PatreonEffectConfig> effects = new ArrayList<PatreonEffectConfig>();
        for (PatreonEffectConfig eff2 : PatreonEffects.allEffects()) {
            if (eff2.tier > this.tier) continue;
            effects.add(eff2);
        }
        this.addRenderableWidget((GuiEventListener)CycleButton.builder(idF).withValues(effects).withInitialValue((Object)this.effect).create(this.width / 2 - 125, this.height / 8, 250, 20, (Component)Component.translatable((String)"tenshilib.patreon.id"), (cycleButton, eff) -> {
            this.effect = eff;
            if (!this.effect.locationAllowed(this.renderLocation)) {
                this.renderLocation = this.effect.defaultLoc();
            }
            this.update();
            this.init();
        }));
        this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.render).create(this.width / 2 - 125, this.height / 8 + (yOffset += 24), 250, 20, (Component)Component.translatable((String)"tenshilib.patreon.render"), (cycleButton, boolean_) -> {
            this.render = boolean_;
            this.update();
        }));
        yOffset += 24;
        yOffset += this.setLocationButton();
        if (this.effect != null && this.effect.guiElements().contains((Object)GuiElement.COLOR)) {
            this.red = new HorizontalColorSlider(this.width / 2 - 125, this.height / 8 + yOffset, 250, 14, new Color(0, true), new Color(255, 0, 0), slider -> this.updateColorString(), (Component)Component.translatable((String)"tenshilib.patreon.slider.red"));
            this.addRenderableWidget((GuiEventListener)this.red);
            this.red.with(this.color);
            this.green = new HorizontalColorSlider(this.width / 2 - 125, this.height / 8 + (yOffset += 18), 250, 14, new Color(0, true), new Color(0, 255, 0), slider -> this.updateColorString(), (Component)Component.translatable((String)"tenshilib.patreon.slider.green"));
            this.addRenderableWidget((GuiEventListener)this.green);
            this.green.with(this.color);
            this.blue = new HorizontalColorSlider(this.width / 2 - 125, this.height / 8 + (yOffset += 18), 250, 14, new Color(0, true), new Color(0, 0, 255), slider -> this.updateColorString(), (Component)Component.translatable((String)"tenshilib.patreon.slider.blue"));
            this.addRenderableWidget((GuiEventListener)this.blue);
            this.blue.with(this.color);
            this.alpha = new HorizontalColorSlider(this.width / 2 - 125, this.height / 8 + (yOffset += 18), 250, 14, new Color(0, false), new Color(255, 255, 255), slider -> this.updateColorString(), (Component)Component.translatable((String)"tenshilib.patreon.slider.alpha"));
            this.addRenderableWidget((GuiEventListener)this.alpha);
            this.alpha.with(this.color);
            yOffset += 24;
            this.txtField = new EditBox(this, this.minecraft.font, this.width / 2 - 155 + 160, this.height / 8 + 144, 150, 20, (Component)Component.translatable((String)"tenshilib.patreon.color")){

                public boolean charTyped(char codePoint, int modifiers) {
                    if (this.getValue().length() > 8) {
                        return false;
                    }
                    return HexFormat.isHexDigit(codePoint) && super.charTyped(codePoint, modifiers);
                }
            };
            this.txtField.setValue(HexFormat.of().toHexDigits(this.color));
            this.txtField.setResponder(s -> {
                this.color = s.isEmpty() ? -1 : HexFormat.fromHexDigits(s);
                this.update();
            });
            this.addRenderableWidget((GuiEventListener)this.txtField);
            yOffset += 18;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"tenshilib.patreon.save"), button -> {
            if (this.effect != null) {
                LoaderNetwork.INSTANCE.sendToServer(new C2SEffectUpdatePkt(this.effect.id(), this.render, this.renderLocation, this.color));
            }
        }).pos(this.width / 2 - 100, this.height / 8 + yOffset).size(200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)name, button -> this.minecraft.setScreen(this.parent)).pos(this.width / 2 - 100, this.height / 8 + (yOffset += 24)).size(200, 20).build());
    }

    private void updateColorString() {
        this.color = new Color(this.red.getColor().add(this.green.getColor()).add(this.blue.getColor()), this.alpha.getColor().getAlpha()).hex();
        this.update();
        this.txtField.setValue(HexFormat.of().toHexDigits(this.color));
    }

    private void update() {
        this.setting.update(this.effect, this.renderLocation, this.render, this.color);
    }

    private int setLocationButton() {
        if (this.effect == null || !this.effect.guiElements().contains((Object)GuiElement.LOCATION)) {
            return 0;
        }
        ArrayList<RenderLocation> allowed = new ArrayList<RenderLocation>();
        for (RenderLocation l : RenderLocation.values()) {
            if (this.effect != null && !this.effect.locationAllowed(l)) continue;
            allowed.add(l);
        }
        if (allowed.isEmpty()) {
            return 0;
        }
        Function<RenderLocation, Component> f = loc -> Component.translatable((String)("tenshilib.patreon.location." + loc.toString()));
        this.addRenderableWidget((GuiEventListener)CycleButton.builder(f).withValues(allowed).withInitialValue((Object)this.renderLocation).create(this.width / 2 - 125, this.height / 8 + 48, 250, 20, (Component)Component.translatable((String)"tenshilib.patreon.location"), (cycleButton, loc) -> {
            this.renderLocation = loc;
            this.update();
        }));
        return 24;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 12, 0xFFFFFF);
        if (this.tier == 0) {
            guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"tenshilib.patreon.not").withStyle(ChatFormatting.DARK_RED), this.width / 2, 46, 0xFFFFFF);
        }
        if (this.tier > 0) {
            int scale = 65;
            int sizeX = 100 * scale / 30;
            int sizeY = 100 * scale / 30;
            int ex = this.width / 2 - 180 - sizeX / 2;
            int ey = this.height / 8 + 120 - sizeY / 2;
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)ex, (int)ey, (int)(ex + sizeX), (int)(ey + sizeY), (int)scale, (float)0.0625f, (float)mouseX, (float)((float)mouseY + 0.625f * (float)scale), (LivingEntity)this.minecraft.player);
            if (this.effect != null && this.effect.guiElements().contains((Object)GuiElement.COLOR)) {
                guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"tenshilib.patreon.color"), this.width / 2 - 55, this.height / 8 + 144 + 8, 0xFFFFFF);
            }
        }
    }

    public void removed() {
        super.removed();
        if (Minecraft.getInstance().getConnection() != null) {
            LoaderNetwork.INSTANCE.sendToServer(C2SRequestUpdateClientPkt.INSTANCE);
        }
    }
}

