/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.entity;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationHandler<T extends Entity> {
    public static final int DEFAULT_TRANSIT_TIME = 3;
    public static final int FALLBACK_TRANSIT_TIME = -1;
    private final T entity;
    private final AnimatedAction[] anims;
    private final List<PriorityEntry<Predicate<AnimatedAction>>> animationChangeListener = new ArrayList<PriorityEntry<Predicate<AnimatedAction>>>();
    private final List<PriorityEntry<Consumer<AnimatedAction>>> onRunAnimation = new ArrayList<PriorityEntry<Consumer<AnimatedAction>>>();
    private ToFloatFunction<AnimatedAction> animationSpeedHandler;
    private AnimatedAction currentAnimation;
    private AnimatedAction lastAnimation;
    private int timeSinceLastChange = -1;

    public AnimationHandler(T entity, AnimatedAction[] anims) {
        this.entity = entity;
        Objects.requireNonNull(anims);
        this.anims = anims;
    }

    public AnimationHandler<T> withChangeListener(Predicate<AnimatedAction> onAnimationSet) {
        return this.withChangeListener(-1, onAnimationSet);
    }

    public AnimationHandler<T> withChangeListener(int priority, Predicate<AnimatedAction> onAnimationSet) {
        if (priority == -1) {
            this.animationChangeListener.add(new PriorityEntry<Predicate<AnimatedAction>>(priority, onAnimationSet));
        } else {
            this.animationChangeListener.add(new PriorityEntry<Predicate<AnimatedAction>>(priority, onAnimationSet));
            this.animationChangeListener.sort(Comparator.reverseOrder());
        }
        return this;
    }

    public AnimationHandler<T> withHandle(Consumer<AnimatedAction> handleAction) {
        return this.withHandle(-1, handleAction);
    }

    public AnimationHandler<T> withHandle(int priority, Consumer<AnimatedAction> handleAction) {
        if (priority == -1) {
            this.onRunAnimation.add(new PriorityEntry<Consumer<AnimatedAction>>(priority, handleAction));
        } else {
            this.onRunAnimation.add(new PriorityEntry<Consumer<AnimatedAction>>(priority, handleAction));
            this.onRunAnimation.sort(Comparator.reverseOrder());
        }
        return this;
    }

    public AnimationHandler<T> withAnimationSpeedHandler(ToFloatFunction<AnimatedAction> animationSpeedHandler) {
        this.animationSpeedHandler = animationSpeedHandler;
        return this;
    }

    @Nullable
    public AnimatedAction getAnimation() {
        return this.currentAnimation;
    }

    public void runIfAnimation(String id, Consumer<AnimatedAction> anim) {
        if (this.isCurrent(id)) {
            anim.accept(this.getAnimation());
        }
    }

    public void runIfNotNull(Consumer<AnimatedAction> cons) {
        if (this.currentAnimation != null) {
            cons.accept(this.currentAnimation);
        }
    }

    public boolean hasAnimation() {
        return this.currentAnimation != null;
    }

    public void setAnimation(AnimatedAction anim) {
        this.setAnimation(anim, -1, -1, 0.0f);
    }

    public void setAnimation(AnimatedAction anim, int startTransition, int endTransition, float offset) {
        for (PriorityEntry<Predicate<AnimatedAction>> listener : this.animationChangeListener) {
            if (!listener.val().test(anim)) continue;
            return;
        }
        if (this.currentAnimation != null) {
            this.lastAnimation = this.currentAnimation;
            this.timeSinceLastChange = 0;
            if (anim != null) {
                startTransition = startTransition > 0 ? startTransition : this.lastAnimation.getEndTransitionTime();
                this.lastAnimation = this.lastAnimation.create(this.currentAnimation.getStartTransition(), startTransition, this.currentAnimation.getTick(1.0f), this.currentAnimation.getSpeed());
            }
        } else if (this.lastAnimation != null && anim != null) {
            this.lastAnimation = this.lastAnimation.create(this.lastAnimation.getStartTransition(), startTransition + this.timeSinceLastChange, this.lastAnimation.getTick(1.0f), this.lastAnimation.getSpeed());
        }
        AnimatedAction animatedAction = anim == null ? null : (this.currentAnimation = anim.create(startTransition, endTransition, offset, this.animationSpeedHandler == null ? anim.getSpeed() : this.animationSpeedHandler.m_183321_((Object)anim)));
        if (!((Entity)this.entity).f_19853_.f_46443_) {
            EventCalls.INSTANCE.sendEntityAnimationPacket(this.entity, startTransition, endTransition, offset);
        }
    }

    public AnimatedAction[] getAnimations() {
        return this.anims;
    }

    public boolean isCurrent(AnimatedAction ... anims) {
        for (AnimatedAction action : anims) {
            if (!action.is(this.getAnimation())) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrent(String ... ids) {
        if (!this.hasAnimation()) {
            return false;
        }
        for (String id : ids) {
            if (!this.getAnimation().getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    public int getTimeSinceLastChange() {
        return this.timeSinceLastChange;
    }

    public AnimatedAction getLastAnimation() {
        return this.lastAnimation;
    }

    public void tick() {
        ++this.timeSinceLastChange;
        if (this.lastAnimation != null && this.timeSinceLastChange > this.lastAnimation.getEndTransitionTime()) {
            this.lastAnimation = null;
        }
        if (this.hasAnimation()) {
            if (this.getAnimation().tick()) {
                this.setAnimation(null);
            } else {
                this.onRunAnimation.forEach(p -> ((Consumer)p.val()).accept(this.getAnimation()));
            }
        }
    }

    public void finishAnimation() {
        AnimatedAction anim = this.getAnimation();
        if (anim != null) {
            while (!anim.done(1)) {
                anim.tick();
            }
            if (anim.shouldRunOut()) {
                this.setAnimation(null);
            } else {
                this.timeSinceLastChange = Mth.m_14167_((float)anim.getLength());
            }
        }
    }

    public float getCurrentTransitionProgress(float partialTicks) {
        if (this.currentAnimation == null) {
            return 1.0f;
        }
        return this.currentAnimation.getStartTransitionProgress(partialTicks);
    }

    public float getLastTransitionProgress(float partialTicks) {
        if (this.lastAnimation == null) {
            return 0.0f;
        }
        return 1.0f - Mth.m_14036_((float)(((float)(this.getTimeSinceLastChange() - 1) + partialTicks) / (float)this.lastAnimation.getEndTransitionTime()), (float)0.0f, (float)1.0f);
    }

    private record PriorityEntry<T>(int priority, T val) implements Comparable<PriorityEntry<T>>
    {
        @Override
        public int compareTo(@NotNull PriorityEntry<T> other) {
            return Integer.compare(this.priority(), other.priority());
        }
    }
}

