/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client;

import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.api.entity.IOverlayEntityRender;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.api.item.IExtendedWeapon;
import io.github.flemmli97.tenshilib.client.CustomRiderRendererManager;
import io.github.flemmli97.tenshilib.client.gui.AnimationScreen;
import io.github.flemmli97.tenshilib.common.item.AnimationDebugger;
import io.github.flemmli97.tenshilib.common.network.C2SPacketHit;
import io.github.flemmli97.tenshilib.common.network.NetworkCrossPlat;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;

public class ClientHandlers {
    public static final Set<UUID> RIDING_RENDER_BLACKLIST = new HashSet<UUID>();

    public static void updateAnim(int entityID, int animID, int startTransition, int endTransition, float start) {
        Minecraft mc = Minecraft.m_91087_();
        Entity e = mc.f_91073_.m_6815_(entityID);
        if (e instanceof IAnimated) {
            IAnimated anim = (IAnimated)e;
            anim.getAnimationHandler().setAnimation(animID < 0 ? null : anim.getAnimationHandler().getAnimations()[animID], startTransition, endTransition, start);
        }
    }

    public static int getColor(LivingEntity entity, float f) {
        IOverlayEntityRender overlay = (IOverlayEntityRender)entity;
        int oV = (int)(f * 15.0f);
        int oU = entity.f_20916_ > 0 || entity.f_20919_ > 0 ? 3 : 10;
        return OverlayTexture.m_118093_((int)overlay.overlayU(oV), (int)overlay.overlayV(oU));
    }

    public static Player clientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static boolean shouldDisableRender(Entity entity) {
        Entity entity2 = entity.m_20202_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            if (CustomRiderRendererManager.getInstance().hasRiderLayerRenderer(vehicle.m_6095_())) {
                if (RIDING_RENDER_BLACKLIST.contains(entity.m_142081_())) {
                    return false;
                }
                return entity != Minecraft.m_91087_().f_91074_ || !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
            }
        }
        return false;
    }

    public static boolean emptyClick() {
        IAOEWeapon aoe;
        Item item;
        Minecraft client = Minecraft.m_91087_();
        ItemStack main = client.f_91074_.m_21205_();
        if (client.f_91077_ != null && (client.f_91077_.m_6662_() != HitResult.Type.BLOCK || (item = main.m_41720_()) instanceof IAOEWeapon && !(aoe = (IAOEWeapon)item).allowBlockAttack((LivingEntity)client.f_91074_, main))) {
            Item item2 = main.m_41720_();
            if (item2 instanceof IExtendedWeapon) {
                IExtendedWeapon weapon = (IExtendedWeapon)item2;
                NetworkCrossPlat.INSTANCE.sendToServer(new C2SPacketHit(C2SPacketHit.HitType.EXT));
                if (weapon.resetAttackStrength((LivingEntity)client.f_91074_, main)) {
                    client.f_91074_.m_36334_();
                }
                if (weapon.swingWeapon((LivingEntity)client.f_91074_, main)) {
                    client.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                }
                return true;
            }
            item2 = main.m_41720_();
            if (item2 instanceof IAOEWeapon) {
                IAOEWeapon weapon = (IAOEWeapon)item2;
                NetworkCrossPlat.INSTANCE.sendToServer(new C2SPacketHit(C2SPacketHit.HitType.AOE));
                if (weapon.resetAttackStrength((LivingEntity)client.f_91074_, main)) {
                    client.f_91074_.m_36334_();
                }
                if (weapon.swingWeapon((LivingEntity)client.f_91074_, main)) {
                    client.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                }
                return true;
            }
        }
        return false;
    }

    public static <T extends LivingEntity> void openAnimationGui(T entity, InteractionHand hand) {
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof AnimationDebugger) {
            AnimationDebugger debug = (AnimationDebugger)item;
            Minecraft.m_91087_().m_91152_(new AnimationScreen<T>(entity, hand, debug.getIndex(stack)));
        }
    }
}

