/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui.widget.list;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableEntry;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class SelectableListWidget
extends AbstractWidget {
    private final Font font;
    private final List<SelectableEntry> entries;
    private final boolean[] selected;
    private int entryHeight;
    private int limit;
    private ResourceLocation background;
    private int paddingY = 4;
    private boolean canSelectMultiple;
    private int offset;
    private int hovered;
    private int lastSelect;

    public SelectableListWidget(int x, int y, int width, int height, Font font, List<SelectableEntry> entries) {
        super(x, y, width, height, (Component)new TextComponent(""));
        this.font = font;
        this.entries = entries;
        this.selected = new boolean[this.entries.size()];
        Objects.requireNonNull(this.font);
        this.entryHeight = 9 + 3 + this.paddingY;
        this.entries.forEach(e -> e.updateDimensions(this.f_93618_, this.entryHeight));
        this.limit = height / this.entryHeight;
    }

    public SelectableListWidget withPadding(int paddingY) {
        this.paddingY = paddingY;
        Objects.requireNonNull(this.font);
        this.entryHeight = 9 + 3 + this.paddingY;
        this.entries.forEach(e -> e.updateDimensions(this.f_93618_, this.entryHeight));
        this.limit = this.f_93619_ / this.entryHeight;
        return this;
    }

    public SelectableListWidget withTexture(ResourceLocation background) {
        this.background = background;
        return this;
    }

    public SelectableListWidget selectMultiple() {
        this.canSelectMultiple = true;
        return this;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.background != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.background);
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 0, 0, this.f_93618_, this.f_93619_);
        }
        this.hoverOver(this.f_93622_ ? this.indexFromMouse(mouseY) : -1);
        for (int i = 0; i < this.entries.size(); ++i) {
            int idxx = (this.offset + i) % this.entries.size();
            if (i >= this.limit || idxx >= this.entries.size()) break;
            SelectableEntry entry = this.entries.get(idxx);
            boolean selected = this.selected[idxx];
            boolean hovered = this.hovered == idxx;
            int entryY = this.f_93621_ + i * this.entryHeight;
            entry.render(this, poseStack, mouseX, mouseY, partialTick, this.f_93620_, entryY, selected, hovered);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!super.m_6375_(mouseX, mouseY, button)) {
            return false;
        }
        int i = this.indexFromMouse(mouseY);
        if (i != -1) {
            this.hoverOver(i);
            int entryX = this.f_93620_;
            int entryY = this.f_93621_ + i * this.entryHeight;
            double relMouseX = mouseX - (double)entryX;
            double relMouseY = mouseY - (double)entryY;
            if (!this.canSelectMultiple && this.lastSelect != this.hovered) {
                this.selected[this.lastSelect] = false;
                this.entries.get(this.lastSelect).unSelect();
            }
            this.lastSelect = this.hovered;
            boolean selected = this.selected[this.hovered];
            this.selected[this.hovered] = !this.selected[this.hovered];
            SelectableEntry entry = this.entries.get(this.hovered);
            if (selected && !this.selected[this.hovered]) {
                entry.unSelect();
            }
            if (!entry.onClick(relMouseX, relMouseY, this.selected[this.hovered])) {
                this.selected[this.hovered] = false;
            } else {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }
        }
        return true;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return super.m_93680_(mouseX, mouseY) && this.indexFromMouse(mouseY) != -1;
    }

    public void m_7435_(SoundManager handler) {
    }

    private int indexFromMouse(double mouseY) {
        double relativePos = mouseY - (double)this.f_93621_;
        if (relativePos < 0.0 || relativePos > (double)(this.f_93621_ + this.f_93619_)) {
            return -1;
        }
        int idx = (int)(relativePos / (double)this.entryHeight + (double)this.offset);
        if (idx >= this.entries.size() || idx >= this.offset + this.limit) {
            return -1;
        }
        return idx;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        super.m_6050_(mouseX, mouseY, delta);
        if (this.f_93622_) {
            this.offset = Mth.m_14045_((int)((int)((double)this.offset - delta)), (int)0, (int)Math.max(this.entries.size() - this.limit, 0));
            return true;
        }
        return false;
    }

    public void m_142291_(NarrationElementOutput output) {
    }

    public void hoverOver(int index) {
        this.hovered = index;
        if (this.hovered != -1) {
            if (this.hovered < 0) {
                this.hovered += this.entries.size();
            }
            if (this.hovered >= this.entries.size()) {
                this.hovered -= this.entries.size();
            }
        }
    }

    public Font getFont() {
        return this.font;
    }
}

