/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import io.github.flemmli97.tenshilib.api.entity.IBeamEntity;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public abstract class RenderBeam<T extends Entity>
extends EntityRenderer<T> {
    protected final float radius;
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    protected int alpha = 255;
    protected final float[][] points;
    protected final float[][] pointsGlow;

    public RenderBeam(EntityRendererProvider.Context ctx, float width) {
        this(ctx, width, 4);
    }

    public RenderBeam(EntityRendererProvider.Context ctx, float width, int polygon) {
        this(ctx, width, width - 0.25f, polygon);
    }

    public RenderBeam(EntityRendererProvider.Context ctx, float glowWidth, float innerWidth, int polygon) {
        super(ctx);
        this.radius = glowWidth;
        this.points = MathUtils.createRegularPolygonPointsF(polygon, innerWidth);
        this.pointsGlow = MathUtils.createRegularPolygonPointsF(polygon, glowWidth);
    }

    public void setColor(int hexColor) {
        this.setColorAndAlpha(hexColor >> 16 & 0xFF, hexColor >> 8 & 0xFF, hexColor & 0xFF, hexColor >> 24 & 0xFF);
    }

    public void setColor(int red, int green, int blue) {
        this.red = red;
        this.blue = blue;
        this.green = green;
    }

    public void setColorAndAlpha(int red, int green, int blue, int alpha) {
        this.red = red;
        this.blue = blue;
        this.green = green;
        this.alpha = alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void m_7392_(T entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        boolean playerView;
        ((IBeamEntity)entity).updateYawPitch();
        float dist = (float)((IBeamEntity)entity).hitVec().m_82554_(((IBeamEntity)entity).startVec());
        float width = this.widthFunc(entity);
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(Mth.m_14179_((float)partialTicks, (float)((Entity)entity).f_19859_, (float)entity.m_146908_()) + 90.0f));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-Mth.m_14179_((float)partialTicks, (float)((Entity)entity).f_19860_, (float)entity.m_146909_())));
        boolean bl = playerView = !((IBeamEntity)entity).firstPerson3d(Minecraft.m_91087_().f_91075_) && Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.THIRD_PERSON_BACK;
        if (playerView) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(30.0f));
            matrixStack.m_85837_(0.0, -0.1, 0.0);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(60.0f));
        } else {
            matrixStack.m_85841_(1.0f, width, width);
        }
        this.renderBeam(entity, dist, width, matrixStack, buffer, packedLight, playerView);
        matrixStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void renderBeam(T entity, float dist, float width, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, boolean playerView) {
        int d;
        float[] fArray;
        int alphaPre;
        float startLength = 0.0f;
        if (this.startTexture(entity) != null) {
            startLength = Math.min(this.startTexture(entity).size(), dist * 0.5f);
            if (playerView) {
                this.renderBeam(matrixStack, buffer.m_6299_(this.getRenderLayer(entity, this.startTexture(entity).res())), 0.0f, startLength, width, -width, this.currentAnimation(entity, BeamPart.START), this.animationFrames(BeamPart.START), packedLight, true);
            } else {
                this.render3dBeam(matrixStack, buffer.m_6299_(this.getRenderLayer(entity, this.startTexture(entity).res())), this.points, 0.0f, startLength, this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
                alphaPre = this.alpha;
                this.setAlpha(this.glowAlpha(entity));
                this.render3dBeam(matrixStack, buffer.m_6299_(this.getGlowingRenderLayer(entity, this.startTexture(entity).res())), this.pointsGlow, 0.0f, startLength, this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
                this.setAlpha(alphaPre);
            }
        }
        float length = dist - startLength;
        if (this.endTexture(entity) != null) {
            float endLength = Math.min(this.endTexture(entity).size(), length);
            length -= endLength;
            if (playerView) {
                this.renderBeam(matrixStack, buffer.m_6299_(this.getRenderLayer(entity, this.endTexture(entity).res())), startLength + length, endLength, width, -width, this.currentAnimation(entity, BeamPart.END), this.animationFrames(BeamPart.END), packedLight, true);
            } else {
                this.render3dBeam(matrixStack, buffer.m_6299_(this.getRenderLayer(entity, this.startTexture(entity).res())), this.points, startLength + length, endLength, this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
                alphaPre = this.alpha;
                this.setAlpha(this.glowAlpha(entity));
                this.render3dBeam(matrixStack, buffer.m_6299_(this.getGlowingRenderLayer(entity, this.startTexture(entity).res())), this.pointsGlow, startLength + length, endLength, this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
                this.setAlpha(alphaPre);
            }
        }
        VertexConsumer builder = buffer.m_6299_(this.getRenderLayer(entity, this.m_5478_((Entity)entity)));
        if (this.segmentLength() == 0.0f) {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = length;
        } else {
            fArray = this.split(length);
        }
        float[] segments = fArray;
        for (d = 0; d < segments.length; ++d) {
            if (playerView) {
                this.renderBeam(matrixStack, builder, startLength + (float)d * this.segmentLength(), segments[d], width, -width, this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight, true);
                continue;
            }
            this.render3dBeam(matrixStack, builder, this.points, startLength + (float)d * this.segmentLength(), segments[d], this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
        }
        if (!playerView) {
            alphaPre = this.alpha;
            this.setAlpha(this.glowAlpha(entity));
            builder = buffer.m_6299_(this.getGlowingRenderLayer(entity, this.m_5478_((Entity)entity)));
            for (d = 0; d < segments.length; ++d) {
                this.render3dBeam(matrixStack, builder, this.pointsGlow, startLength + (float)d * this.segmentLength(), segments[d], this.currentAnimation(entity, BeamPart.MIDDLE), this.animationFrames(BeamPart.MIDDLE), packedLight);
            }
            this.setAlpha(alphaPre);
        }
    }

    protected void render3dBeam(PoseStack stack, VertexConsumer build, float[][] corners, float minX, float length, int animationFrame, float maxFrames, int light) {
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        Matrix3f mat3f = stack.m_85850_().m_85864_();
        float vMin = (float)(animationFrame - 1) / maxFrames;
        float vMax = (float)animationFrame / maxFrames;
        for (int i = 0; i < corners.length; ++i) {
            float[] point = corners[i];
            float[] next = i + 1 < corners.length ? corners[i + 1] : corners[0];
            this.buildQuad(matrix4f, mat3f, build, minX, length, point[0], next[0], point[1], next[1], vMin, vMax, light, true);
        }
    }

    protected void renderBeam(PoseStack stack, VertexConsumer build, float minX, float length, float minY, float maxY, int animationFrame, float maxFrames, int light, boolean bothSided) {
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        Matrix3f mat3f = stack.m_85850_().m_85864_();
        this.buildQuad(matrix4f, mat3f, build, minX, length, minY, maxY, 0.0f, 0.0f, (float)(animationFrame - 1) / maxFrames, (float)animationFrame / maxFrames, light, bothSided);
    }

    protected void buildQuad(Matrix4f matrix4f, Matrix3f mat3f, VertexConsumer build, float minX, float length, float minY, float maxY, float minZ, float maxZ, float vMin, float vMax, int light, boolean bothSided) {
        this.buildVertex(matrix4f, mat3f, build, minX, minY, minZ, 0.0f, Math.max(0.0f, vMin), 0.0f, 0.0f, 1.0f, light);
        this.buildVertex(matrix4f, mat3f, build, minX + length, minY, minZ, 1.0f, Math.max(0.0f, vMin), 0.0f, 0.0f, 1.0f, light);
        this.buildVertex(matrix4f, mat3f, build, minX + length, maxY, maxZ, 1.0f, Math.min(1.0f, vMax), 0.0f, 0.0f, 1.0f, light);
        this.buildVertex(matrix4f, mat3f, build, minX, maxY, maxZ, 0.0f, Math.min(1.0f, vMax), 0.0f, 0.0f, 1.0f, light);
        if (bothSided) {
            this.buildVertex(matrix4f, mat3f, build, minX, maxY, maxZ, 0.0f, Math.min(1.0f, vMax), 0.0f, 0.0f, 1.0f, light);
            this.buildVertex(matrix4f, mat3f, build, minX + length, maxY, maxZ, 1.0f, Math.min(1.0f, vMax), 0.0f, 0.0f, 1.0f, light);
            this.buildVertex(matrix4f, mat3f, build, minX + length, minY, minZ, 1.0f, Math.max(0.0f, vMin), 0.0f, 0.0f, 1.0f, light);
            this.buildVertex(matrix4f, mat3f, build, minX, minY, minZ, 0.0f, Math.max(0.0f, vMin), 0.0f, 0.0f, 1.0f, light);
        }
    }

    protected void buildVertex(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer builder, float x, float y, float z, float u, float v, float nX, float nY, float nZ, int light) {
        builder.m_85982_(matrix4f, x, y, z).m_6122_(this.red, this.green, this.blue, this.alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(matrix3f, nX, nY, nZ).m_5752_();
    }

    public abstract ResourcePair startTexture(T var1);

    public abstract ResourcePair endTexture(T var1);

    public float widthFunc(T entity) {
        return (float)((double)(((IBeamEntity)entity).radius() * 2.0f) * Math.sin(Math.sqrt((float)((Entity)entity).f_19797_ / (float)((IBeamEntity)entity).livingTickMax()) * Math.PI));
    }

    public float segmentLength() {
        return 0.0f;
    }

    public int animationFrames(BeamPart part) {
        return 1;
    }

    public int currentAnimation(T entity, BeamPart part) {
        return ((Entity)entity).f_19797_ % this.animationFrames(part) + 1;
    }

    protected float[] split(float length) {
        int arrL = (int)Math.ceil(length / this.segmentLength());
        float[] arr = new float[arrL];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Math.max(0.0f, length - (float)i * this.segmentLength());
        }
        return arr;
    }

    protected RenderType getRenderLayer(T entity, ResourceLocation loc) {
        return RenderType.m_110460_((ResourceLocation)loc, (boolean)false);
    }

    protected RenderType getGlowingRenderLayer(T entity, ResourceLocation loc) {
        return RenderType.m_110460_((ResourceLocation)loc, (boolean)true);
    }

    protected int glowAlpha(T entity) {
        return 35;
    }

    public record ResourcePair(ResourceLocation res, float size) {
    }

    public static enum BeamPart {
        START,
        END,
        MIDDLE;

    }
}

