/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AnimatedAttackGoal<T extends PathfinderMob>
extends Goal {
    public final T attacker;
    protected final List<WeightedEntry.Wrapper<GoalAttackAction<T>>> actions;
    protected final List<WeightedEntry.Wrapper<IdleAction<T>>> idleActions;
    protected final boolean checkRestriction;
    protected LivingEntity target;
    @Nullable
    public GoalAttackAction.ActiveAction<T> current;
    protected GoalAttackAction.ActiveAction<T> previous;
    protected List<GoalAttackAction.ChainedAction> chained;
    private ActionRun<T> onIdle;
    private boolean reset;
    protected Vec3 lastPathTargetPos;
    protected int idleTime;
    protected int prepare;
    protected int chainSelect;
    public double distanceToTargetSq;
    public boolean canSee;

    public AnimatedAttackGoal(T entity, List<WeightedEntry.Wrapper<GoalAttackAction<T>>> actions, List<WeightedEntry.Wrapper<IdleAction<T>>> idleActions) {
        this(entity, actions, idleActions, true);
    }

    public AnimatedAttackGoal(T entity, List<WeightedEntry.Wrapper<GoalAttackAction<T>>> actions, List<WeightedEntry.Wrapper<IdleAction<T>>> idleActions, boolean checkRestriction) {
        this.attacker = entity;
        this.actions = actions;
        this.idleActions = idleActions;
        this.checkRestriction = checkRestriction;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity living = this.attacker.m_5448_();
        return !this.actions.isEmpty() && living != null && living.m_6084_() && (!this.checkRestriction || this.attacker.m_21444_(living.m_142538_()));
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8041_() {
        this.current = null;
        this.previous = null;
        this.chained = null;
        this.target = null;
        this.reset = false;
        this.lastPathTargetPos = null;
        this.idleTime = 0;
        this.prepare = 0;
        this.attacker.m_21573_().m_26573_();
        this.attacker.m_21564_(0.0f);
        this.attacker.m_21570_(0.0f);
    }

    protected void resetAttack() {
        this.current = null;
        this.reset = false;
        this.onIdle = null;
        this.lastPathTargetPos = null;
        this.chained = null;
        this.chainSelect = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void setupValues() {
        this.target = this.attacker.m_5448_();
        if (((PathfinderMob)this.attacker).f_19797_ % 10 != 0) {
            return;
        }
        this.distanceToTargetSq = this.attacker.m_20280_((Entity)this.target);
        this.canSee = this.attacker.m_21574_().m_148306_((Entity)this.target);
    }

    protected void selectNextAction() {
        this.resetAttack();
        List<WeightedEntry.Wrapper> idles = this.idleActions.stream().filter(d -> ((IdleAction)d.m_146310_()).test(this, this.target)).toList();
        IdleAction idle = WeightedRandom.m_146317_((Random)this.attacker.m_21187_(), idles).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
        ActionRun actionRun = this.onIdle = idle != null ? idle.runner.create() : null;
        if (idle != null) {
            this.onIdle = idle.runner.create();
            this.idleTime = idle.getDuration().getInt(this.attacker);
        } else {
            this.idleTime = 20;
        }
        List<WeightedEntry.Wrapper> selectables = this.actions.stream().filter(d -> ((GoalAttackAction)d.m_146310_()).test(this, this.target, this.previous != null ? this.previous.anim().getID() : "")).toList();
        GoalAttackAction action = WeightedRandom.m_146317_((Random)this.attacker.m_21187_(), selectables).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
        GoalAttackAction.ActiveAction activeAction = this.current = action != null ? action.createActive() : null;
        if (action != null) {
            this.prepare = this.current.start().timeout().getInt(this.attacker);
            this.idleTime = action.getCooldown().getInt(this.attacker);
            if (action.getChainedAction() != null) {
                this.chained = action.getChainedAction().get(this.attacker);
            }
        }
    }

    public void m_8037_() {
        if (this.attacker.m_5448_() == null) {
            return;
        }
        this.setupValues();
        AnimatedAction anim = ((IAnimated)this.attacker).getAnimationHandler().getAnimation();
        if (anim != null) {
            if (this.current != null && this.current.anim().is(anim)) {
                this.current.runner().run(this, this.target, anim);
            }
            return;
        }
        if (this.reset) {
            this.reset = false;
            this.current = null;
        }
        if (this.current == null) {
            if (this.chained != null) {
                GoalAttackAction.ChainedAction action = this.chained.get(this.chainSelect);
                ((IAnimated)this.attacker).getAnimationHandler().setAnimation(action.anim(), action.transitionTime(), -1, action.offset());
                ++this.chainSelect;
                if (this.chainSelect >= this.chained.size()) {
                    this.chained = null;
                }
                return;
            }
            if (--this.idleTime > 0) {
                if (this.onIdle != null) {
                    this.onIdle.run(this, this.target, null);
                }
                return;
            }
        }
        if (this.current == null) {
            this.selectNextAction();
            return;
        }
        if (--this.prepare >= 0) {
            boolean done = this.current.start().start(this, this.target);
            if (done) {
                this.prepare = -1;
            } else if (this.prepare == 0) {
                this.resetAttack();
                return;
            }
        }
        if (this.prepare == -1) {
            ((IAnimated)this.attacker).getAnimationHandler().setAnimation(this.current.anim());
            this.reset = true;
            this.previous = this.current;
        }
    }

    public void resetCooldown() {
        this.idleTime = 0;
    }

    public void moveToTargetPosition(double x, double y, double z, double speed) {
        if (this.lastPathTargetPos == null || this.attacker.m_21573_().m_26571_() || this.lastPathTargetPos.m_82531_(x, y, z) > 4.0) {
            this.lastPathTargetPos = new Vec3(x, y, z);
            Path path = this.attacker.m_21573_().m_26524_(x, y, z, 0);
            if (path != null) {
                this.attacker.m_21573_().m_26536_(path, speed);
            }
        }
    }

    public void moveToTarget(double speed) {
        this.moveToTargetPosition(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_(), speed);
    }

    public void circleAround(double posX, double posZ, float radius, boolean clockWise, float speed) {
        double z;
        double x = this.attacker.m_20185_() - posX;
        double r = x * x + (z = this.attacker.m_20189_() - posZ) * z;
        if (r < ((double)radius - 1.5) * ((double)radius - 1.5) || r > ((double)radius + 1.5) * ((double)radius + 1.5)) {
            double[] c = MathUtils.closestOnCircle(posX, posZ, this.attacker.m_20185_(), this.attacker.m_20189_(), radius);
            this.attacker.m_21573_().m_26519_(c[0], this.attacker.m_20186_(), c[1], (double)speed);
        } else {
            double angle = MathUtils.phiFromPoint(posX, posZ, this.attacker.m_20185_(), this.attacker.m_20189_()) + (double)(clockWise ? MathUtils.degToRad(15.0f) : -MathUtils.degToRad(15.0f));
            double nPosX = (double)radius * Math.cos(angle);
            double nPosZ = (double)radius * Math.sin(angle);
            this.attacker.m_21573_().m_26519_(posX + nPosX, this.attacker.m_20186_(), posZ + nPosZ, (double)speed);
        }
    }
}

