/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated.impl;

import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;

public class ActionUtils {
    public static <T extends PathfinderMob> GoalAttackAction.Condition<T> ranged(double range) {
        return (goal, target, previousAnim) -> goal.distanceToTargetSq < range * range;
    }

    public static <T extends PathfinderMob> GoalAttackAction.Condition<T> rangedVisible(double range) {
        return (goal, target, previousAnim) -> goal.canSee && goal.distanceToTargetSq < range * range;
    }

    public static <T extends PathfinderMob> GoalAttackAction<T> failedStart() {
        return new GoalAttackAction(null);
    }

    public static <T extends PathfinderMob> GoalAttackAction.Condition<T> chanced(FloatGetter<T> chance) {
        return (goal, target, previousAnim) -> goal.attacker.m_21187_().nextFloat() < chance.get(goal.attacker);
    }

    public static <T extends PathfinderMob> GoalAttackAction.Condition<T> chanced(FloatGetter<T> chance, GoalAttackAction.Condition<T> other) {
        return (goal, target, previousAnim) -> {
            if (goal.attacker.m_21187_().nextFloat() < chance.get(goal.attacker)) {
                return other.test(goal, target, previousAnim);
            }
            return false;
        };
    }

    public static PathDistance distanceToNavTargetSqr(Mob entity) {
        if (entity.m_21573_().m_26571_()) {
            return null;
        }
        Vec3 pos = entity.m_20182_();
        Vec3 target = entity.m_21573_().m_26570_().m_77380_((Entity)entity);
        return new PathDistance(pos.m_82557_(target), entity.m_21573_().m_26570_().m_77399_());
    }

    public static interface FloatGetter<T> {
        public float get(T var1);
    }

    public record PathDistance(double dist, int index) {
    }
}

