/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity.ai.animated.impl;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class KeepDistanceRunner<T extends PathfinderMob>
implements ActionRun<T> {
    private final double speed;
    private final double maxDistSqr;
    private final double minDistSqr;
    private final int dist;
    private final boolean needsLoS;
    private int moveType;
    private ActionUtils.PathDistance pathDist;

    public KeepDistanceRunner(double minDist, double maxDist) {
        this(minDist, maxDist, 1.0, true);
    }

    public KeepDistanceRunner(double minDist, double maxDist, double speed) {
        this(minDist, maxDist, speed, true);
    }

    public KeepDistanceRunner(double minDist, double maxDist, double speed, boolean needsLoS) {
        this.speed = speed;
        this.maxDistSqr = maxDist * maxDist;
        this.minDistSqr = minDist * minDist;
        this.dist = Mth.m_14165_((double)(maxDist - minDist));
        this.needsLoS = needsLoS;
    }

    @Override
    public boolean run(AnimatedAttackGoal<T> goal, LivingEntity target, AnimatedAction anim) {
        switch (this.moveType) {
            case 0: {
                if (goal.distanceToTargetSq > this.maxDistSqr || !this.canSee(goal)) {
                    goal.moveToTarget(this.speed);
                    this.moveType = 1;
                    break;
                }
                if (!(goal.distanceToTargetSq < this.minDistSqr)) break;
                for (int i = 0; i < 10; ++i) {
                    Vec3 posAway = DefaultRandomPos.m_148407_(goal.attacker, (int)this.dist, (int)4, (Vec3)target.m_20182_());
                    if (posAway == null) continue;
                    goal.moveToTargetPosition(posAway.m_7096_(), posAway.m_7098_(), posAway.m_7094_(), this.speed);
                    break;
                }
                this.moveType = 2;
                break;
            }
            case 1: {
                if (goal.distanceToTargetSq < this.maxDistSqr && this.canSee(goal)) {
                    goal.attacker.m_21573_().m_26573_();
                    return true;
                }
                goal.moveToTarget(this.speed);
                break;
            }
            case 2: {
                if (((PathfinderMob)goal.attacker).f_19797_ % 3 == 0) {
                    ActionUtils.PathDistance lastCheck = this.pathDist;
                    this.pathDist = ActionUtils.distanceToNavTargetSqr(goal.attacker);
                    if (lastCheck != null && this.pathDist != null && lastCheck.index() == this.pathDist.index() && lastCheck.dist() + 2.0 <= this.pathDist.dist()) {
                        this.moveType = 0;
                        return false;
                    }
                }
                if (!this.canSee(goal)) {
                    this.moveType = 0;
                    return false;
                }
                if (!(goal.distanceToTargetSq > this.maxDistSqr)) break;
                goal.attacker.m_21573_().m_26573_();
                return true;
            }
        }
        goal.attacker.m_21391_((Entity)target, 30.0f, 30.0f);
        return goal.attacker.m_21573_().m_26571_() && this.canSee(goal);
    }

    private boolean canSee(AnimatedAttackGoal<T> goal) {
        return !this.needsLoS || goal.canSee;
    }
}

