/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class SpawnEgg
extends SpawnEggItem {
    private static final Map<Supplier<? extends EntityType<?>>, SpawnEgg> EGGS_SUP = Maps.newIdentityHashMap();
    private static final Map<EntityType<?>, SpawnEgg> EGGS = Maps.newIdentityHashMap();
    private static final Map<EntityType<? extends Mob>, SpawnEggItem> BY_ID = SpawnEgg.fetchMapFromSpawnEgg();
    private static boolean resolved;
    protected static final DispenseItemBehavior DEF;
    private final Supplier<? extends EntityType<?>> type;
    private final boolean mob;

    public SpawnEgg(Supplier<? extends EntityType<?>> type, int primary, int secondary, Item.Properties props) {
        super(null, primary, secondary, props);
        BY_ID.remove(null);
        this.type = type;
        this.mob = false;
        this.onInit(type);
    }

    public SpawnEgg(EntityTypeHolder<?> type, int primary, int secondary, Item.Properties props) {
        super(null, primary, secondary, props);
        BY_ID.remove(null);
        this.type = type.type;
        this.mob = Mob.class.isAssignableFrom(type.clss);
        this.onInit(type.type);
    }

    private static Map<EntityType<? extends Mob>, SpawnEggItem> fetchMapFromSpawnEgg() {
        for (Field f : SpawnEggItem.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Map.class.isAssignableFrom(f.getType())) continue;
            try {
                f.setAccessible(true);
                Object obj = f.get(null);
                if (!(obj instanceof IdentityHashMap)) continue;
                return (Map)f.get(null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("Couldn't find spawnegg map");
    }

    public static void resolveEggs() {
        if (resolved) {
            return;
        }
        resolved = true;
        EGGS_SUP.forEach((type, egg) -> {
            if (egg.addToDefaultSpawneggs() && egg.mob) {
                BY_ID.put((EntityType<? extends Mob>)((EntityType)type.get()), (SpawnEggItem)egg);
            }
            EGGS.put((EntityType<?>)((EntityType)type.get()), (SpawnEgg)((Object)egg));
        });
    }

    protected void onInit(Supplier<? extends EntityType<?>> type) {
        EGGS_SUP.put(type, this);
    }

    public static Iterable<SpawnEgg> getEggs() {
        return Iterables.unmodifiableIterable(EGGS_SUP.values());
    }

    public static Optional<SpawnEgg> fromType(EntityType<?> type) {
        SpawnEgg.resolveEggs();
        return Optional.ofNullable(EGGS.get(type));
    }

    public static Optional<SpawnEgg> fromID(ResourceLocation id) {
        return PlatformUtils.INSTANCE.entities().getOptionalFromId(id).flatMap(SpawnEgg::fromType);
    }

    public boolean onEntitySpawned(Entity e, ItemStack stack, @Nullable Player player) {
        return true;
    }

    public Component getEntityName(ItemStack stack) {
        return stack.m_41788_() ? stack.m_41786_() : null;
    }

    public DispenseItemBehavior dispenser() {
        return DEF;
    }

    public boolean addToDefaultSpawneggs() {
        return true;
    }

    public Component m_7626_(ItemStack stack) {
        return new TranslatableComponent(this.m_5671_(stack), new Object[]{new TranslatableComponent(this.m_43228_(stack.m_41783_()).m_20675_())});
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockEntity tile;
        Level world = ctx.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = ctx.m_43722_();
        BlockPos blockpos = ctx.m_8083_();
        Direction direction = ctx.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        InteractionResult onBlock = this.onBlockUse(stack, blockpos, blockstate, tile = world.m_7702_(blockpos));
        if (onBlock != InteractionResult.PASS) {
            return onBlock;
        }
        if (tile instanceof SpawnerBlockEntity) {
            BaseSpawner abstractspawner = ((SpawnerBlockEntity)tile).m_59801_();
            EntityType<?> entitytype1 = this.m_43228_(stack.m_41783_());
            abstractspawner.m_45462_(entitytype1);
            tile.m_6596_();
            world.m_7260_(blockpos, blockstate, blockstate, 3);
            stack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_142300_(direction);
        Entity e = SpawnEgg.spawnEntity((ServerLevel)world, ctx.m_43723_(), stack, blockpos1, MobSpawnType.SPAWN_EGG, true, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP);
        if (e != null) {
            stack.m_41774_(1);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResult onBlockUse(ItemStack stack, BlockPos pos, BlockState state, @Nullable BlockEntity tile) {
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult raytraceresult = SpawnEgg.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        BlockPos blockpos = raytraceresult.m_82425_();
        if (!(world.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (world.m_7966_(player, blockpos) && player.m_36204_(blockpos, raytraceresult.m_82434_(), stack)) {
            Entity e = SpawnEgg.spawnEntity((ServerLevel)world, player, stack, blockpos, MobSpawnType.SPAWN_EGG, true, true, false);
            if (e != null) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public static Entity spawnEntity(ServerLevel world, Player player, ItemStack stack, BlockPos pos, MobSpawnType reason, boolean forgeCheck, boolean updateLocation, boolean doCollisionOffset) {
        Item item = stack.m_41720_();
        if (!(item instanceof SpawnEgg)) {
            return null;
        }
        SpawnEgg item2 = (SpawnEgg)item;
        EntityType<?> type = item2.m_43228_(stack.m_41783_());
        Entity e = type.m_20655_(world, stack.m_41783_(), item2.getEntityName(stack), player, pos, reason, updateLocation, doCollisionOffset);
        if (e != null) {
            if (!item2.onEntitySpawned(e, stack, player) || forgeCheck && e instanceof Mob && EventCalls.INSTANCE.specialSpawnCall((Mob)e, (Level)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), null, reason)) {
                return null;
            }
            world.m_47205_(e);
        }
        return e;
    }

    public int getColor(ItemStack stack, int i) {
        return super.m_43211_(i);
    }

    public EntityType<?> m_43228_(@Nullable CompoundTag nbt) {
        CompoundTag compoundnbt;
        if (nbt != null && nbt.m_128425_("EntityTag", 10) && (compoundnbt = nbt.m_128469_("EntityTag")).m_128425_("id", 8)) {
            EntityType<?> type = PlatformUtils.INSTANCE.entities().getFromId(new ResourceLocation(compoundnbt.m_128461_("id")));
            return type != null ? type : this.type.get();
        }
        return this.type.get();
    }

    static {
        DEF = (blockSource, stack) -> {
            Direction direction = (Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            SpawnEgg.spawnEntity(blockSource.m_7727_(), null, stack, blockSource.m_7961_().m_142300_(direction), MobSpawnType.DISPENSER, false, direction != Direction.UP, false);
            stack.m_41774_(1);
            return stack;
        };
    }

    public record EntityTypeHolder<T extends Entity>(Class<T> clss, Supplier<? extends EntityType<? extends T>> type) {
    }
}

