/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OrientedBoundingBox {
    private AABB baseBox;
    private AABB outerBox;
    private float yRot;
    private float xRot;
    private Vec3 offset;
    private final Vec3[] vertices = new Vec3[8];
    private Vec3 axisX;
    private Vec3 axisY;
    private Vec3 axisZ;

    public OrientedBoundingBox(AABB box) {
        this(box, 0.0f, 0.0f, Vec3.f_82478_);
    }

    public OrientedBoundingBox(AABB box, float yRot, float xRot) {
        this(box, yRot, xRot, Vec3.f_82478_);
    }

    public OrientedBoundingBox(AABB box, Vec3 offset) {
        this(box, 0.0f, 0.0f, offset);
    }

    public OrientedBoundingBox(AABB box, float yRot, float xRot, Vec3 offset) {
        this.baseBox = box;
        this.yRot = yRot;
        this.xRot = xRot;
        this.offset = offset;
        this.compute();
    }

    public static AABB baseBox(double width, double height, double length) {
        return new AABB(-width * 0.5, -height * 0.5, 0.0, width * 0.5, height * 0.5, length);
    }

    public static AABB originAABB(Entity entity) {
        return entity.m_142469_().m_82383_(entity.m_20182_().m_82490_(-1.0));
    }

    public static OrientedBoundingBox fromBuffer(FriendlyByteBuf buf) {
        return new OrientedBoundingBox(new AABB(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readFloat(), buf.readFloat(), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
    }

    private static boolean collides(Vec3[] firstBoxVertices, Vec3[] secondBoxVertices, Vec3[] axes) {
        for (Vec3 axis : axes) {
            Projection second;
            Projection first = OrientedBoundingBox.projectOntoAxis(firstBoxVertices, axis);
            if (OrientedBoundingBox.overlap(first, second = OrientedBoundingBox.projectOntoAxis(secondBoxVertices, axis))) continue;
            return false;
        }
        return true;
    }

    private static Projection projectOntoAxis(Vec3[] vertices, Vec3 axis) {
        double min;
        double max = min = axis.m_82526_(vertices[0]);
        for (Vec3 vertex : vertices) {
            double projection = axis.m_82526_(vertex);
            if (projection < min) {
                min = projection;
            }
            if (!(projection > max)) continue;
            max = projection;
        }
        return new Projection(min, max);
    }

    private static boolean overlap(Projection first, Projection second) {
        return first.max >= second.min && second.max >= first.min;
    }

    public OrientedBoundingBox rotate(float yRot, float xRot) {
        this.yRot = yRot;
        this.xRot = xRot;
        this.compute();
        return this;
    }

    public OrientedBoundingBox move(double x, double y, double z) {
        return this.move(new Vec3(x, y, z));
    }

    public OrientedBoundingBox move(Vec3 offset) {
        this.offset = this.offset.m_82549_(offset);
        this.compute();
        return this;
    }

    public OrientedBoundingBox setPos(double x, double y, double z) {
        return this.move(new Vec3(x, y, z));
    }

    public OrientedBoundingBox setPos(Vec3 offset) {
        this.offset = offset;
        this.compute();
        return this;
    }

    public OrientedBoundingBox inflate(double val) {
        return this.inflate(val, val, val);
    }

    public OrientedBoundingBox inflate(double x, double y, double z) {
        this.baseBox = this.baseBox.m_82377_(x, y, z);
        this.compute();
        return this;
    }

    public OrientedBoundingBox apply(Function<AABB, AABB> func) {
        this.baseBox = func.apply(this.baseBox);
        this.compute();
        return this;
    }

    public boolean intersects(OrientedBoundingBox box) {
        Vec3[] axis = new Vec3[]{this.axisX, this.axisY, this.axisZ, box.axisX, box.axisY, box.axisZ};
        return OrientedBoundingBox.collides(this.vertices, box.vertices, axis);
    }

    public boolean intersects(AABB aabb) {
        if (this.xRot == 0.0f && this.yRot == 0.0f) {
            return this.baseBox.m_82383_(this.offset).m_82381_(aabb);
        }
        Vec3[] axis = new Vec3[]{this.axisX, this.axisY, this.axisZ, new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, 1.0)};
        Vec3[] verticesAABB = new Vec3[]{new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_), new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82290_), new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82293_), new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82293_), new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82290_), new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82290_), new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_), new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82293_)};
        return OrientedBoundingBox.collides(this.vertices, verticesAABB, axis);
    }

    public <T extends Entity> List<T> intersectingEntities(Level level, LivingEntity entity, boolean ignoreBlocks, EntityTypeTest<Entity, T> typeTest, Predicate<T> pred) {
        BlockCollisionDetector collisionDetector = ignoreBlocks ? null : new BlockCollisionDetector(level, this, (Entity)entity);
        return this.intersectingEntities(level, collisionDetector, typeTest, pred);
    }

    public <T extends Entity> List<T> intersectingEntities(Level level, BlockCollisionDetector collisionDetector, EntityTypeTest<Entity, T> typeTest, Predicate<T> pred) {
        AABB box = this.getEncompassingBox();
        List list = level.m_142425_(typeTest, box, pred);
        list.removeIf(e -> !this.intersects(e.m_142469_()) || collisionDetector != null && !collisionDetector.noBlockCollide((Entity)e));
        return list;
    }

    public boolean collidesBlocks(Level level, @Nullable Entity entity) {
        for (VoxelShape shape : level.m_186434_(entity, this.getEncompassingBox())) {
            if (!this.intersects(shape.m_83215_())) continue;
            return true;
        }
        return false;
    }

    public AABB getBaseBox() {
        return this.baseBox;
    }

    public AABB getEncompassingBox() {
        return this.outerBox;
    }

    public float getXRot() {
        return this.xRot;
    }

    public float getYRot() {
        return this.yRot;
    }

    public Vec3[] getVertices() {
        return this.vertices;
    }

    public Vec3 getOffset() {
        return this.offset;
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.writeDouble(this.baseBox.f_82291_);
        buf.writeDouble(this.baseBox.f_82292_);
        buf.writeDouble(this.baseBox.f_82293_);
        buf.writeDouble(this.baseBox.f_82288_);
        buf.writeDouble(this.baseBox.f_82289_);
        buf.writeDouble(this.baseBox.f_82290_);
        buf.writeFloat(this.yRot);
        buf.writeFloat(this.xRot);
        buf.writeDouble(this.offset.f_82479_);
        buf.writeDouble(this.offset.f_82480_);
        buf.writeDouble(this.offset.f_82481_);
    }

    private void compute() {
        float xRotRad = (float)Math.PI / 180 * this.xRot;
        float yRotRad = (float)(-Math.PI) / 180 * this.yRot;
        this.vertices[0] = new Vec3(this.baseBox.f_82288_, this.baseBox.f_82289_, this.baseBox.f_82290_).m_82496_(xRotRad).m_82524_(yRotRad).m_82549_(this.offset);
        this.vertices[1] = new Vec3(this.baseBox.f_82291_, this.baseBox.f_82289_, this.baseBox.f_82290_).m_82496_(xRotRad).m_82524_(yRotRad).m_82549_(this.offset);
        this.vertices[2] = new Vec3(this.baseBox.f_82291_, this.baseBox.f_82289_, this.baseBox.f_82293_).m_82496_(xRotRad).m_82524_(yRotRad).m_82549_(this.offset);
        this.vertices[3] = new Vec3(this.baseBox.f_82288_, this.baseBox.f_82289_, this.baseBox.f_82293_).m_82496_(xRotRad).m_82524_(yRotRad).m_82549_(this.offset);
        this.vertices[4] = new Vec3(this.baseBox.f_82288_, this.baseBox.f_82292_, this.baseBox.f_82290_).m_82496_(xRotRad).m_82524_(yRotRad).m_82549_(this.offset);
        this.vertices[5] = new Vec3(this.baseBox.f_82291_, this.baseBox.f_82292_, this.baseBox.f_82290_).m_82496_(xRotRad).m_82524_(yRotRad).m_82549_(this.offset);
        this.vertices[6] = new Vec3(this.baseBox.f_82291_, this.baseBox.f_82292_, this.baseBox.f_82293_).m_82496_(xRotRad).m_82524_(yRotRad).m_82549_(this.offset);
        this.vertices[7] = new Vec3(this.baseBox.f_82288_, this.baseBox.f_82292_, this.baseBox.f_82293_).m_82496_(xRotRad).m_82524_(yRotRad).m_82549_(this.offset);
        this.axisX = new Vec3(1.0, 0.0, 0.0).m_82496_(xRotRad).m_82524_(yRotRad);
        this.axisY = new Vec3(0.0, 1.0, 0.0).m_82496_(xRotRad).m_82524_(yRotRad);
        this.axisZ = new Vec3(0.0, 0.0, 1.0).m_82496_(xRotRad).m_82524_(yRotRad);
        double minX = this.vertices[0].m_7096_();
        double minY = this.vertices[0].m_7098_();
        double minZ = this.vertices[0].m_7094_();
        double maxX = this.vertices[0].m_7096_();
        double maxY = this.vertices[0].m_7098_();
        double maxZ = this.vertices[0].m_7094_();
        for (Vec3 vertices : this.vertices) {
            if (vertices.f_82479_ < minX) {
                minX = vertices.f_82479_;
            } else if (vertices.f_82479_ > maxX) {
                maxX = vertices.f_82479_;
            }
            if (vertices.f_82480_ < minY) {
                minY = vertices.f_82480_;
            } else if (vertices.f_82480_ > maxY) {
                maxY = vertices.f_82480_;
            }
            if (vertices.f_82481_ < minZ) {
                minZ = vertices.f_82481_;
                continue;
            }
            if (!(vertices.f_82481_ > maxZ)) continue;
            maxZ = vertices.f_82481_;
        }
        this.outerBox = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public String toString() {
        return String.format("OBB[aabb=%s, yRot=%s, xRot=%s, offset=%s]", this.baseBox, Float.valueOf(this.yRot), Float.valueOf(this.xRot), this.offset);
    }

    private record Projection(double min, double max) {
    }

    public static class BlockCollisionDetector {
        private final BlockGetter blockGetter;
        private final Vec3 from;
        private final Entity source;

        public BlockCollisionDetector(Level level, OrientedBoundingBox obb, Entity source) {
            AABB box = obb.getEncompassingBox();
            BlockPos first = new BlockPos(box.f_82288_, box.f_82289_, box.f_82290_);
            BlockPos second = new BlockPos(Mth.m_14165_((double)box.f_82291_), Mth.m_14165_((double)box.f_82292_), Mth.m_14165_((double)box.f_82293_));
            this.blockGetter = new PathNavigationRegion(level, first, second);
            this.from = obb.getOffset();
            this.source = source;
        }

        /*
         * WARNING - void declaration
         */
        public boolean noBlockCollide(Entity entity) {
            int ySplit;
            AABB aabb = entity.m_142469_();
            if (this.blockGetter.m_45547_(new ClipContext(this.from, entity.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.source)).m_6662_() == HitResult.Type.MISS) {
                return true;
            }
            ArrayList<Object> points = new ArrayList<Object>();
            ArrayList<Vec3> maxYs = new ArrayList<Vec3>();
            points.add(new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_));
            points.add(new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82290_));
            points.add(new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82293_));
            points.add(new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82293_));
            maxYs.add(new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82290_));
            maxYs.add(new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82290_));
            maxYs.add(new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_));
            maxYs.add(new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82293_));
            int xSplit = (int)((double)entity.m_20205_() / 0.4);
            if (xSplit > 0) {
                void var8_9;
                double xStep = entity.m_20205_() / (float)(++xSplit);
                boolean bl = true;
                while (var8_9 < xSplit) {
                    points.add(new Vec3(aabb.f_82288_ + (double)var8_9 * xStep, aabb.f_82289_, aabb.f_82290_));
                    points.add(new Vec3(aabb.f_82288_ + (double)var8_9 * xStep, aabb.f_82289_, aabb.f_82293_));
                    points.add(new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_ + (double)var8_9 * xStep));
                    points.add(new Vec3(aabb.f_82291_, aabb.f_82289_, aabb.f_82290_ + (double)var8_9 * xStep));
                    maxYs.add(new Vec3(aabb.f_82288_ + (double)var8_9 * xStep, aabb.f_82292_, aabb.f_82290_));
                    maxYs.add(new Vec3(aabb.f_82288_ + (double)var8_9 * xStep, aabb.f_82292_, aabb.f_82293_));
                    maxYs.add(new Vec3(aabb.f_82288_, aabb.f_82292_, aabb.f_82290_ + (double)var8_9 * xStep));
                    maxYs.add(new Vec3(aabb.f_82291_, aabb.f_82292_, aabb.f_82290_ + (double)var8_9 * xStep));
                    ++var8_9;
                }
            }
            if ((ySplit = (int)((double)entity.m_20206_() / 0.5)) > 0) {
                double yStep = entity.m_20206_() / (float)(++ySplit);
                ArrayList<Vec3> verticals = new ArrayList<Vec3>();
                for (int y = 1; y < ySplit; ++y) {
                    for (Vec3 vec3 : points) {
                        verticals.add(new Vec3(vec3.m_7096_(), aabb.f_82289_ + (double)y * yStep, vec3.m_7094_()));
                    }
                }
                points.addAll(verticals);
            }
            points.addAll(maxYs);
            for (Vec3 vec3 : points) {
                if (this.blockGetter.m_45547_(new ClipContext(this.from, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.source)).m_6662_() != HitResult.Type.MISS) continue;
                return true;
            }
            return false;
        }
    }
}

