/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class RayTraceUtils {
    public static List<Entity> getEntitiesIn(LivingEntity entity, OrientedBoundingBox obb, Predicate<Entity> pred) {
        return RayTraceUtils.getEntitiesIn(entity, obb, false, EntityTypeTest.m_156916_(Entity.class), pred);
    }

    public static <T extends Entity> List<T> getEntitiesIn(LivingEntity entity, OrientedBoundingBox obb, EntityTypeTest<Entity, T> typeTest, Predicate<T> pred) {
        return RayTraceUtils.getEntitiesIn(entity, obb, false, typeTest, pred);
    }

    public static <T extends Entity> List<T> getEntitiesIn(LivingEntity entity, OrientedBoundingBox obb, boolean ignoreBlocks, EntityTypeTest<Entity, T> typeTest, Predicate<T> pred) {
        return obb.intersectingEntities(entity.f_19853_, entity, ignoreBlocks, typeTest, t -> t != entity && (pred == null || pred.test(t)) && !t.m_7307_((Entity)entity) && t.m_6087_());
    }

    public static EntityHitResult calculateEntityFromLook(LivingEntity entity, float reach) {
        return RayTraceUtils.calculateEntityFromLook(entity, entity.m_20299_(1.0f), entity.m_20252_(1.0f), reach, null);
    }

    public static EntityHitResult calculateEntityFromLook(LivingEntity entity, Vec3 pos, Vec3 dir, float reach, @Nullable Predicate<Entity> pred) {
        Vec3 loc;
        double dist;
        Vec3 scaledDir = dir.m_82490_((double)reach);
        EntityHitResult result = RayTraceUtils.rayTraceEntities(entity.f_19853_, (Entity)entity, pos, pos.m_82549_(scaledDir), entity.m_142469_().m_82369_(scaledDir).m_82400_(1.0), t -> EntitySelector.f_20408_.test(t) && t.m_6087_() && (pred == null || pred.test((Entity)t)), (ToFloatFunction<Entity>)((ToFloatFunction)Entity::m_6143_));
        if (result != null && (dist = pos.m_82557_(loc = result.m_82450_())) <= (double)(reach * reach)) {
            return result;
        }
        return null;
    }

    @Nullable
    public static BlockPos randomPosAround(Level world, Entity e, BlockPos pos, int range, boolean grounded, Random rand) {
        int randX = pos.m_123341_() + rand.nextInt(2 * range) - range;
        int randY = pos.m_123342_() + rand.nextInt(2 * range) - range;
        int randZ = pos.m_123343_() + rand.nextInt(2 * range) - range;
        if (!grounded) {
            BlockPos pos1 = new BlockPos(randX, randY, randZ);
            while (Math.abs(randY - pos1.m_123342_()) < range && !world.m_45772_(e.m_142469_().m_82338_(pos1))) {
                pos1 = pos1.m_7494_();
            }
            if (!world.m_45772_(e.m_142469_().m_82338_(pos1))) {
                return null;
            }
            return pos1;
        }
        int y = pos.m_123342_() - range;
        BlockPos pos1 = new BlockPos(randX, y, randZ);
        while (!(pos1.m_123342_() - y >= range || world.m_8055_(pos1.m_7495_()).m_60638_((BlockGetter)world, pos1.m_7495_(), e, Direction.UP) && world.m_45772_(e.m_142469_().m_82338_(pos1)))) {
            pos1 = pos1.m_7494_();
        }
        if (!world.m_45772_(e.m_142469_().m_82338_(pos1))) {
            return null;
        }
        return pos1;
    }

    public static HitResult entityRayTrace(Entity e, float range, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, boolean includeEntities, boolean getEntityHitVec, @Nullable Predicate<Entity> pred) {
        if (pred == null) {
            pred = entity -> true;
        }
        Vec3 posEye = e.m_20299_(1.0f);
        Vec3 dir = e.m_20154_().m_82490_((double)range);
        Vec3 lookPos = posEye.m_82549_(dir);
        if (includeEntities) {
            EntityHitResult entityHitResult;
            BlockHitResult raytraceresult = e.f_19853_.m_45547_(new ClipContext(posEye, lookPos, blockMode, fluidMode, e));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
                lookPos = raytraceresult.m_82450_();
            }
            if ((entityHitResult = getEntityHitVec ? RayTraceUtils.rayTraceEntities(e.f_19853_, e, posEye, lookPos, e.m_142469_().m_82369_(dir).m_82400_(1.0), pred, (ToFloatFunction<Entity>)((ToFloatFunction)ent -> 0.3f)) : ProjectileUtil.m_37304_((Level)e.f_19853_, (Entity)e, (Vec3)posEye, (Vec3)lookPos, (AABB)e.m_142469_().m_82369_(dir).m_82400_(1.0), pred)) != null) {
                raytraceresult = entityHitResult;
            }
            return raytraceresult;
        }
        return e.f_19853_.m_45547_(new ClipContext(posEye, lookPos, blockMode, fluidMode, e));
    }

    @Nullable
    public static EntityHitResult rayTraceEntities(Entity e, Vec3 from, Vec3 to, Predicate<Entity> pred) {
        return RayTraceUtils.rayTraceEntities(e.f_19853_, e, from, to, e.m_142469_().m_82369_(e.m_20184_()).m_82400_(1.0), pred, (ToFloatFunction<Entity>)((ToFloatFunction)ent -> 0.3f));
    }

    @Nullable
    public static EntityHitResult rayTraceEntities(Level world, Entity e, Vec3 from, Vec3 to, AABB aabb, Predicate<Entity> pred, ToFloatFunction<Entity> inflateRadius) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        Vec3 hit = null;
        for (Entity entity1 : world.m_6249_(e, aabb, pred)) {
            AABB axisalignedbb = entity1.m_142469_().m_82400_((double)inflateRadius.m_183321_((Object)entity1));
            if (axisalignedbb.m_82390_(from)) {
                entity = entity1;
                hit = from;
                if (axisalignedbb.m_82390_(to)) break;
                hit = axisalignedbb.m_82371_(from, to).orElse(from);
                break;
            }
            Optional optional = axisalignedbb.m_82371_(from, to);
            if (!optional.isPresent()) continue;
            if (d0 == 0.0) {
                entity = entity1;
                hit = (Vec3)optional.get();
                break;
            }
            double d1 = from.m_82557_((Vec3)optional.get());
            if (!(d1 < d0)) continue;
            entity = entity1;
            d0 = d1;
            hit = (Vec3)optional.get();
        }
        return entity == null ? null : new EntityHitResult(entity, hit);
    }

    public static EntityHitResult projectileRayTrace(Level world, Entity entity, Vec3 from, Vec3 to, AABB check, Predicate<Entity> pred, double radius) {
        double distVar = Double.MAX_VALUE;
        Entity ret = null;
        from = from.m_82520_(0.0, (double)entity.m_20206_() * 0.5, 0.0);
        Vec3 dir = to.m_82546_(from);
        AABB entityBB = entity.m_142469_();
        for (Entity entity1 : world.m_6249_(entity, check, pred)) {
            AABB axisalignedbb = entity1.m_142469_().m_82400_((double)0.3f);
            Pair<Vec3, Vec3> points = MathUtils.closestPointsAABB(entityBB, axisalignedbb);
            double dist = ((Vec3)points.getLeft()).m_82557_((Vec3)points.getRight());
            if (!(dist < distVar) || !(dist <= radius * radius) || radius != 0.0 && !MathUtils.isInFront(entity1.m_20182_(), from, dir)) continue;
            ret = entity1;
            distVar = dist;
        }
        return ret == null ? null : new EntityHitResult(ret);
    }

    public static List<Vector3f> rotatedVecs(Vec3 dir, Vec3 axis, float minDeg, float maxDeg, float step) {
        float y;
        ArrayList<Vector3f> list = new ArrayList<Vector3f>();
        Vector3f axisf = new Vector3f(axis);
        list.add(new Vector3f(dir));
        for (y = step; y <= maxDeg; y += step) {
            list.add(RayTraceUtils.rotatedAround(dir, axisf, y));
        }
        for (y = minDeg; y <= -step; y += step) {
            list.add(RayTraceUtils.rotatedAround(dir, axisf, y));
        }
        return list;
    }

    public static Vector3f rotatedAround(Vec3 dir, Vector3f axis, float deg) {
        Quaternion quaternion = new Quaternion(axis, deg, true);
        Vector3f newDir = new Vector3f(dir);
        newDir.m_122251_(quaternion);
        return newDir;
    }
}

