/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils.mathParser;

import io.github.flemmli97.tenshilib.common.utils.mathParser.ExpValue;
import io.github.flemmli97.tenshilib.common.utils.mathParser.VariableMap;

public class BuiltinFunctions {
    public static final double DEG_TO_RAD = Math.PI / 180;

    public record Abs(ExpValue value) implements ExpValue
    {
        @Override
        public double get(VariableMap vars) {
            return Math.abs(this.value.get(vars));
        }

        @Override
        public String toString() {
            return String.format("abs(%s)", this.value);
        }
    }

    public record Cos(ExpValue value) implements ExpValue
    {
        @Override
        public double get(VariableMap vars) {
            return Math.cos(Math.PI / 180 * this.value.get(vars));
        }

        @Override
        public String toString() {
            return String.format("cos(%s)", this.value);
        }
    }

    public record Sin(ExpValue value) implements ExpValue
    {
        @Override
        public double get(VariableMap vars) {
            return Math.sin(Math.PI / 180 * this.value.get(vars));
        }

        @Override
        public String toString() {
            return String.format("sin(%s)", this.value);
        }
    }
}

