/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils.mathParser;

import io.github.flemmli97.tenshilib.common.utils.mathParser.ExpValue;
import io.github.flemmli97.tenshilib.common.utils.mathParser.VariableMap;

public class BuiltinValues {

    public record Division(ExpValue first, ExpValue second) implements ExpValue
    {
        @Override
        public double get(VariableMap vars) {
            return this.first.get(vars) / this.second.get(vars);
        }

        @Override
        public String toString() {
            String f = this.first instanceof ConstantValue || this.first instanceof VariableValue ? this.first.toString() : String.format("(%s)", this.first);
            String s = this.second instanceof ConstantValue || this.second instanceof VariableValue ? this.second.toString() : String.format("(%s)", this.second);
            return String.format("%s/%s", f, s);
        }
    }

    public record Multiplication(ExpValue first, ExpValue second) implements ExpValue
    {
        @Override
        public double get(VariableMap vars) {
            return this.first.get(vars) * this.second.get(vars);
        }

        @Override
        public String toString() {
            String f = this.first instanceof ConstantValue || this.first instanceof VariableValue ? this.first.toString() : String.format("(%s)", this.first);
            String s = this.second instanceof ConstantValue || this.second instanceof VariableValue ? this.second.toString() : String.format("(%s)", this.second);
            return String.format("%s*%s", f, s);
        }
    }

    public record Substraction(ExpValue first, ExpValue second) implements ExpValue
    {
        @Override
        public double get(VariableMap vars) {
            return this.first.get(vars) - this.second.get(vars);
        }

        @Override
        public String toString() {
            String f = this.first instanceof ConstantValue || this.first instanceof VariableValue ? this.first.toString() : String.format("(%s)", this.first);
            String s = this.second instanceof ConstantValue || this.second instanceof VariableValue ? this.second.toString() : String.format("(%s)", this.second);
            return String.format("%s-%s", f, s);
        }
    }

    public record Addition(ExpValue first, ExpValue second) implements ExpValue
    {
        @Override
        public double get(VariableMap vars) {
            return this.first.get(vars) + this.second.get(vars);
        }

        @Override
        public String toString() {
            String f = this.first instanceof ConstantValue || this.first instanceof VariableValue ? this.first.toString() : String.format("(%s)", this.first);
            String s = this.second instanceof ConstantValue || this.second instanceof VariableValue ? this.second.toString() : String.format("(%s)", this.second);
            return String.format("%s+%s", f, s);
        }
    }

    public record VariableValue(String variable) implements ExpValue
    {
        @Override
        public double get(VariableMap vars) {
            return vars.getValue(this.variable);
        }

        @Override
        public String toString() {
            return this.variable;
        }
    }

    public record NegativeValue(ExpValue val) implements ExpValue
    {
        @Override
        public double get(VariableMap vars) {
            return -this.val.get(vars);
        }

        @Override
        public String toString() {
            return "-" + String.valueOf(this.val);
        }
    }

    public record ConstantValue(double constant) implements ExpValue
    {
        @Override
        public double get(VariableMap vars) {
            return this.constant;
        }

        @Override
        public String toString() {
            return "" + this.constant;
        }
    }
}

