/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils.mathParser;

import io.github.flemmli97.tenshilib.common.utils.mathParser.BuiltinValues;
import io.github.flemmli97.tenshilib.common.utils.mathParser.ExpValue;
import io.github.flemmli97.tenshilib.common.utils.mathParser.FunctionRegistry;
import io.github.flemmli97.tenshilib.common.utils.mathParser.VariableMap;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.TestOnly;

public class Expression {
    private static final String NUMBER = "\\d+(?:\\.\\d+)?";
    private static final String VARIABLE = "(?<!\\.)[A-z][A-z._]*";
    private static final String OPERATOR = "[*/+\\-%()]";
    private static final Pattern PATTERN = Pattern.compile(String.format("(?:%1$s)|(?:%2$s)|(?:%3$s)|,", "\\d+(?:\\.\\d+)?", "(?<!\\.)[A-z][A-z._]*", "[*/+\\-%()]"));

    private static String variableEquivalent(String variable) {
        if (variable.equals("anim_time") || variable.equals("time")) {
            variable = "query.anim_time";
        }
        return variable;
    }

    public static ExpValue of(String exp) {
        exp = exp.replace(" ", "");
        Stack<TokenHolder> output = Expression.shuntingYard(exp);
        Stack<ExpValue> vars = new Stack<ExpValue>();
        for (TokenHolder op : output) {
            switch (op.type) {
                case NUMBER: {
                    vars.push(new BuiltinValues.ConstantValue(Float.parseFloat(op.token)));
                    break;
                }
                case VAR: {
                    vars.push(new BuiltinValues.VariableValue(Expression.variableEquivalent(op.token)));
                    break;
                }
                case SUB_UNARY: {
                    ExpValue value = (ExpValue)vars.pop();
                    vars.push(new BuiltinValues.NegativeValue(value));
                    break;
                }
                case ADD: {
                    ExpValue sec = (ExpValue)vars.pop();
                    ExpValue first = vars.pop();
                    vars.push(new BuiltinValues.Addition(first, sec));
                    break;
                }
                case SUB: {
                    ExpValue sec = (ExpValue)vars.pop();
                    ExpValue first = vars.pop();
                    vars.push(new BuiltinValues.Substraction(first, sec));
                    break;
                }
                case MULT: {
                    ExpValue sec = (ExpValue)vars.pop();
                    ExpValue first = vars.pop();
                    vars.push(new BuiltinValues.Multiplication(first, sec));
                    break;
                }
                case DIV: {
                    ExpValue sec = (ExpValue)vars.pop();
                    ExpValue first = vars.pop();
                    vars.push(new BuiltinValues.Division(first, sec));
                    break;
                }
                case FUNC: {
                    ExpValue value = FunctionRegistry.tryConstruct(op.token, vars);
                    if (value == null) break;
                    vars.push(value);
                }
            }
        }
        if (vars.size() > 1) {
            throw new IllegalStateException("Not all tokens processed!");
        }
        return (ExpValue)vars.pop();
    }

    private static Stack<TokenHolder> shuntingYard(String exp) {
        Stack<TokenHolder> output = new Stack<TokenHolder>();
        Stack<TokenHolder> operators = new Stack<TokenHolder>();
        Matcher matcher = PATTERN.matcher(exp);
        Type lastType = null;
        while (matcher.find()) {
            String token = matcher.group();
            Type type = Type.type(token, lastType);
            switch (type) {
                case NUMBER: 
                case VAR: {
                    output.add(new TokenHolder(type, token));
                    break;
                }
                case FUNC: 
                case BRACKETOPEN: {
                    operators.add(new TokenHolder(type, token));
                    break;
                }
                case DELIMITER: {
                    while (!operators.empty() && ((TokenHolder)operators.peek()).type != Type.BRACKETOPEN) {
                        output.add((TokenHolder)operators.pop());
                    }
                    break;
                }
                case BRACKETCLOSE: {
                    while (!operators.empty() && ((TokenHolder)operators.peek()).type != Type.BRACKETOPEN) {
                        output.add((TokenHolder)operators.pop());
                    }
                    if (operators.empty()) {
                        throw new IllegalArgumentException("Mismatched brackets!");
                    }
                    operators.pop();
                    if (((TokenHolder)operators.peek()).type != Type.FUNC) break;
                    output.add((TokenHolder)operators.pop());
                    break;
                }
                case SUB_UNARY: 
                case ADD: 
                case SUB: 
                case MULT: 
                case DIV: 
                case ADD_UNARY: {
                    while (!operators.empty()) {
                        TokenHolder op = (TokenHolder)operators.peek();
                        if (!op.type.isOp() || type.args == 1 && op.type.args == 2 || type.priority > op.type.priority) break;
                        output.add((TokenHolder)operators.pop());
                    }
                    operators.add(new TokenHolder(type, token));
                }
            }
            lastType = type;
        }
        while (!operators.empty()) {
            TokenHolder op = (TokenHolder)operators.pop();
            if (op.type == Type.BRACKETOPEN || op.type == Type.BRACKETCLOSE) {
                throw new IllegalArgumentException("Mismatched brackets!");
            }
            output.push(op);
        }
        return output;
    }

    @TestOnly
    public static void test() {
        ExpValue exp0 = Expression.of("2*4+7");
        ExpValue exp1 = Expression.of("5+7+3+1*6*3+9");
        ExpValue exp2 = Expression.of("5+(44+1)*4*1/6+99");
        ExpValue exp3 = Expression.of("-5+5+(-3*5)");
        ExpValue exp4 = Expression.of("math.sin(time*(44+1)+3)*4*1/6");
        ExpValue exp5 = Expression.of("99*math.cos(1)");
        ExpValue exp6 = Expression.of("-math.sin(time*180)+17.5");
        ExpValue exp7 = Expression.of("math.sin(time*180)-17.5");
        ExpValue exp8 = Expression.of("math.sin(query.anim_time * 1200) * 6 * query.above_top_solid");
        System.out.println("Expression 0: " + String.valueOf(exp0));
        Expression.verify(exp0.get(new VariableMap()), 15.0);
        System.out.println("Expression 1: " + String.valueOf(exp1));
        Expression.verify(exp1.get(new VariableMap()), 42.0);
        System.out.println("Expression 2: " + String.valueOf(exp2));
        Expression.verify(exp2.get(new VariableMap()), 134.0);
        System.out.println("Expression 3: " + String.valueOf(exp3));
        Expression.verify(exp3.get(new VariableMap()), -15.0);
        System.out.println("Expression 4: " + String.valueOf(exp4));
        Expression.verify(Expression.roundDecimal(exp4.get(new VariableMap().setVariable("query.anim_time", () -> 5.0)), 5), -0.49543);
        System.out.println("Expression 5: " + String.valueOf(exp5));
        Expression.verify(Expression.roundDecimal(exp5.get(new VariableMap()), 5), 98.98492);
        System.out.println("Expression 6: " + String.valueOf(exp6));
        Expression.verify(exp6.get(new VariableMap().setVariable("query.anim_time", () -> 0.0)), 17.5);
        System.out.println("Expression 7: " + String.valueOf(exp7));
        Expression.verify(exp7.get(new VariableMap().setVariable("query.anim_time", () -> 0.0)), -17.5);
        System.out.println("Expression 8: " + String.valueOf(exp8));
        Expression.verify(Expression.roundDecimal(exp8.get(new VariableMap().setVariable("query.anim_time", () -> 4.0).setVariable("query.above_top_solid", () -> 9.0)), 3), 46.765);
    }

    private static void verify(double value, double truth) {
        if (value != truth) {
            throw new IllegalStateException(String.format("Wrong value. Expected %s but was %s", truth, value));
        }
    }

    private static double roundDecimal(double value, int decimals) {
        double pow = Math.pow(10.0, decimals);
        return (double)Math.round(value * pow) / pow;
    }

    record TokenHolder(Type type, String token) {
    }

    static enum Type {
        NUMBER(0, 0),
        VAR(0, 0),
        MULT(10, 2),
        DIV(10, 2),
        ADD(5, 2),
        SUB(5, 2),
        SUB_UNARY(100, 1),
        ADD_UNARY(100, 1),
        FUNC(0, -1),
        BRACKETOPEN(999, 0),
        BRACKETCLOSE(999, 0),
        DELIMITER(0, 0);

        public final int priority;
        public final int args;

        private Type(int priority, int args) {
            this.priority = priority;
            this.args = args;
        }

        public boolean isOp() {
            return this == MULT || this == DIV || this == ADD || this == SUB || this == SUB_UNARY || this == ADD_UNARY;
        }

        public static Type type(String s, Type last) {
            Type type;
            switch (s) {
                case ",": {
                    Type type2;
                    type = type2 = DELIMITER;
                    break;
                }
                case "+": {
                    Type type3;
                    if (last == null || last.args == 2 || last == BRACKETOPEN || last == DELIMITER) {
                        Type type4;
                        type = type4 = ADD_UNARY;
                        break;
                    }
                    type = type3 = ADD;
                    break;
                }
                case "-": {
                    Type type5;
                    if (last == null || last.args == 2 || last == BRACKETOPEN || last == DELIMITER) {
                        Type type6;
                        type = type6 = SUB_UNARY;
                        break;
                    }
                    type = type5 = SUB;
                    break;
                }
                case "*": {
                    Type type7;
                    type = type7 = MULT;
                    break;
                }
                case "/": {
                    Type type8;
                    type = type8 = DIV;
                    break;
                }
                case "(": {
                    Type type9;
                    type = type9 = BRACKETOPEN;
                    break;
                }
                case ")": {
                    Type type10;
                    type = type10 = BRACKETCLOSE;
                    break;
                }
                case "math.sin": 
                case "sin": 
                case "math.cos": 
                case "cos": 
                case "math.abs": 
                case "abs": {
                    Type type11;
                    type = type11 = FUNC;
                    break;
                }
                case "math.pi": {
                    Type type12;
                    type = type12 = VAR;
                    break;
                }
                default: {
                    try {
                        Type type13;
                        Double.parseDouble(s);
                        type = type13 = NUMBER;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Type type14;
                        type = type14 = VAR;
                    }
                }
            }
            return type;
        }
    }
}

