/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.forge.network;

import io.github.flemmli97.tenshilib.common.network.PacketRegistrar;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final ResourceLocation CHANNEL_ID = new ResourceLocation("tenshilib", "packets");
    private static final SimpleChannel DISPATCHER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)CHANNEL_ID).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "1").simpleChannel();

    public static void register() {
        int server = PacketRegistrar.registerServerPackets(new PacketRegistrar.ServerPacketRegister(){

            @Override
            public <P> void registerMessage(int index, ResourceLocation id, Class<P> clss, BiConsumer<P, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, P> decoder, BiConsumer<P, ServerPlayer> handler) {
                DISPATCHER.registerMessage(index, clss, encoder, decoder, PacketHandler.handlerServer(handler));
            }
        }, 0);
        PacketRegistrar.registerClientPackets(new PacketRegistrar.ClientPacketRegister(){

            @Override
            public <P> void registerMessage(int index, ResourceLocation id, Class<P> clss, BiConsumer<P, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, P> decoder, Consumer<P> handler) {
                DISPATCHER.registerMessage(index, clss, encoder, decoder, PacketHandler.handlerClient(handler));
            }
        }, server);
    }

    public static <T> void sendToServer(T message) {
        DISPATCHER.sendToServer(message);
    }

    public static <T> void sendToClientChecked(T message, ServerPlayer player) {
        if (PacketHandler.hasChannel(player)) {
            DISPATCHER.sendTo(message, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static <T> void sendToTracking(T message, Entity e) {
        DISPATCHER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> e), message);
    }

    private static boolean hasChannel(ServerPlayer player) {
        ConnectionData data = NetworkHooks.getConnectionData((Connection)player.f_8906_.f_9742_);
        return data != null && data.getChannels().containsKey((Object)CHANNEL_ID);
    }

    private static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> handlerServer(BiConsumer<T, ServerPlayer> handler) {
        return (p, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> PacketHandler.lambda$handlerServer$4(handler, p, (Supplier)ctx));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }

    private static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> handlerClient(Consumer<T> handler) {
        return (p, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> handler.accept(p));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }

    private static /* synthetic */ void lambda$handlerServer$4(BiConsumer handler, Object p, Supplier ctx) {
        handler.accept(p, ((NetworkEvent.Context)ctx.get()).getSender());
    }
}

