/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.forge.platform;

import io.github.flemmli97.tenshilib.common.entity.EntityBeam;
import io.github.flemmli97.tenshilib.common.network.NetworkCrossPlat;
import io.github.flemmli97.tenshilib.common.network.S2CEntityAnimation;
import io.github.flemmli97.tenshilib.forge.events.AOEAttackEvent;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class EventCallsImpl
implements EventCalls {
    @Override
    public boolean aoeAttackCall(Player player, ItemStack stack, List<Entity> list) {
        return MinecraftForge.EVENT_BUS.post((Event)new AOEAttackEvent(player, stack, list));
    }

    @Override
    public boolean playerAttackCall(Player player, Entity target) {
        return ForgeHooks.onPlayerAttackTarget((Player)player, (Entity)target);
    }

    @Override
    public Pair<Boolean, Float> criticalAttackCall(Player player, Entity target, boolean crit, float dmgMod) {
        CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)crit, (float)dmgMod);
        return Pair.of((Object)(hitResult != null ? 1 : 0), (Object)Float.valueOf(hitResult == null ? dmgMod : hitResult.getDamageModifier()));
    }

    @Override
    public void destroyItemCall(Player player, ItemStack stack, InteractionHand hand) {
        ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
    }

    @Override
    public boolean specialSpawnCall(Mob entity, Level world, float x, float y, float z, BaseSpawner spawner, MobSpawnType spawnReason) {
        return ForgeEventFactory.doSpecialSpawn((Mob)entity, (LevelAccessor)world, (float)x, (float)y, (float)z, (BaseSpawner)spawner, (MobSpawnType)spawnReason);
    }

    @Override
    public boolean projectileHitCall(Projectile projectile, HitResult result) {
        return ForgeEventFactory.onProjectileImpact((Projectile)projectile, (HitResult)result);
    }

    @Override
    public boolean beamHitCall(EntityBeam beam, HitResult result) {
        return false;
    }

    @Override
    public <T extends Entity> void sendEntityAnimationPacket(T entity, int startTransition, int endTransition, float start) {
        NetworkCrossPlat.INSTANCE.sendToTracking(S2CEntityAnimation.create(entity, startTransition, endTransition, start), entity);
    }
}

