/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.tenshilib.client.Color;
import io.github.flemmli97.tenshilib.common.network.NetworkCrossPlat;
import io.github.flemmli97.tenshilib.patreon.PatreonDataManager;
import io.github.flemmli97.tenshilib.patreon.PatreonPlatform;
import io.github.flemmli97.tenshilib.patreon.PatreonPlayerSetting;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.client.HorizontalColorSlider;
import io.github.flemmli97.tenshilib.patreon.effects.GuiElement;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffectConfig;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffects;
import io.github.flemmli97.tenshilib.patreon.pkts.C2SEffectUpdatePkt;
import io.github.flemmli97.tenshilib.patreon.pkts.C2SRequestUpdateClientPkt;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PatreonGui
extends Screen {
    public static final int BLACK = -16777216;
    private final Screen parent;
    private PatreonEffectConfig effect;
    private RenderLocation renderLocation;
    private boolean render = true;
    private int color = -1;
    private EditBox txtField;
    private HorizontalColorSlider red;
    private HorizontalColorSlider green;
    private HorizontalColorSlider blue;
    private HorizontalColorSlider alpha;
    private int tier;
    private CycleButton<RenderLocation> locationButton;
    private PatreonPlayerSetting setting;

    public PatreonGui(Screen screen) {
        super((Component)new TranslatableComponent("tenshilib.patreon.title").m_130940_(ChatFormatting.GOLD));
        this.parent = screen;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    protected void m_7856_() {
        this.m_169413_();
        int n = this.tier = this.f_96541_.f_91073_ == null ? -1 : PatreonDataManager.get(this.f_96541_.f_91074_.m_142081_().toString()).tier();
        if (this.tier < 1) {
            TranslatableComponent name = this.tier == -1 ? new TranslatableComponent("tenshilib.patreon.level.no") : new TranslatableComponent("tenshilib.patreon.back");
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 8 + 192, 200, 20, (Component)name, button -> this.f_96541_.m_91152_(this.parent)));
            return;
        }
        Component name = CommonComponents.f_130655_;
        this.setting = PatreonPlatform.INSTANCE.playerSettings((Player)this.f_96541_.f_91074_).orElse(null);
        if (this.setting == null) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 8 + 168, 200, 20, (Component)new TranslatableComponent("tenshilib.patreon.save"), button -> NetworkCrossPlat.INSTANCE.sendToServer(new C2SEffectUpdatePkt(this.effect.id(), this.render, this.renderLocation, this.color))));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 8 + 192, 200, 20, name, button -> this.f_96541_.m_91152_(this.parent)));
            return;
        }
        int yOffset = 0;
        this.effect = this.setting.effect();
        if (this.effect == null) {
            this.effect = PatreonEffects.get(PatreonDataManager.get(this.f_96541_.f_91074_.m_142081_().toString()).defaultEffect());
        }
        this.renderLocation = this.setting.getRenderLocation();
        if (this.effect != null && !this.effect.locationAllowed(this.renderLocation)) {
            this.renderLocation = this.effect.defaultLoc();
        }
        this.render = this.setting.shouldRender();
        this.color = this.setting.getColor();
        Function<PatreonEffectConfig, Component> idF = eff -> new TranslatableComponent("tenshilib.patreon.id." + eff.id());
        ArrayList<PatreonEffectConfig> effects = new ArrayList<PatreonEffectConfig>();
        for (PatreonEffectConfig eff2 : PatreonEffects.allEffects()) {
            if (eff2.tier > this.tier) continue;
            effects.add(eff2);
        }
        this.m_142416_((GuiEventListener)CycleButton.m_168894_(idF).m_168950_(effects).m_168948_((Object)this.effect).m_168936_(this.f_96543_ / 2 - 125, this.f_96544_ / 8, 250, 20, (Component)new TranslatableComponent("tenshilib.patreon.id"), (cycleButton, eff) -> {
            this.effect = eff;
            if (!this.effect.locationAllowed(this.renderLocation)) {
                this.renderLocation = this.effect.defaultLoc();
            }
            this.update();
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)this.render).m_168936_(this.f_96543_ / 2 - 125, this.f_96544_ / 8 + (yOffset += 24), 250, 20, (Component)new TranslatableComponent("tenshilib.patreon.render"), (cycleButton, boolean_) -> {
            this.render = boolean_;
            this.update();
        }));
        yOffset += 24;
        yOffset += this.setLocationButton();
        if (this.effect != null && this.effect.guiElements().contains((Object)GuiElement.COLOR)) {
            this.red = new HorizontalColorSlider(this.f_96543_ / 2 - 125, this.f_96544_ / 8 + yOffset, 250, 14, new Color(0, true), new Color(255, 0, 0), slider -> this.updateColorString(), (Component)new TranslatableComponent("tenshilib.patreon.slider.red"));
            this.m_142416_((GuiEventListener)this.red);
            this.red.with(this.color);
            this.green = new HorizontalColorSlider(this.f_96543_ / 2 - 125, this.f_96544_ / 8 + (yOffset += 18), 250, 14, new Color(0, true), new Color(0, 255, 0), slider -> this.updateColorString(), (Component)new TranslatableComponent("tenshilib.patreon.slider.green"));
            this.m_142416_((GuiEventListener)this.green);
            this.green.with(this.color);
            this.blue = new HorizontalColorSlider(this.f_96543_ / 2 - 125, this.f_96544_ / 8 + (yOffset += 18), 250, 14, new Color(0, true), new Color(0, 0, 255), slider -> this.updateColorString(), (Component)new TranslatableComponent("tenshilib.patreon.slider.blue"));
            this.m_142416_((GuiEventListener)this.blue);
            this.blue.with(this.color);
            this.alpha = new HorizontalColorSlider(this.f_96543_ / 2 - 125, this.f_96544_ / 8 + (yOffset += 18), 250, 14, new Color(0, false), new Color(255, 255, 255), slider -> this.updateColorString(), (Component)new TranslatableComponent("tenshilib.patreon.slider.alpha"));
            this.m_142416_((GuiEventListener)this.alpha);
            this.alpha.with(this.color);
            yOffset += 24;
            this.txtField = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 155 + 160, this.f_96544_ / 8 + 144, 150, 20, (Component)new TranslatableComponent("tenshilib.patreon.color")){

                public boolean m_5534_(char codePoint, int modifiers) {
                    if (this.m_94155_().length() > 8) {
                        return false;
                    }
                    return HexFormat.isHexDigit(codePoint) && super.m_5534_(codePoint, modifiers);
                }
            };
            this.txtField.m_94144_(HexFormat.of().toHexDigits(this.color));
            this.txtField.m_94151_(s -> {
                this.color = s.isEmpty() ? -1 : HexFormat.fromHexDigits(s);
                this.update();
            });
            this.m_142416_((GuiEventListener)this.txtField);
            yOffset += 18;
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 8 + yOffset, 200, 20, (Component)new TranslatableComponent("tenshilib.patreon.save"), button -> {
            if (this.effect != null) {
                NetworkCrossPlat.INSTANCE.sendToServer(new C2SEffectUpdatePkt(this.effect.id(), this.render, this.renderLocation, this.color));
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 8 + (yOffset += 24), 200, 20, name, button -> this.f_96541_.m_91152_(this.parent)));
    }

    private void updateColorString() {
        this.color = new Color(this.red.getColor().add(this.green.getColor()).add(this.blue.getColor()), this.alpha.getColor().getAlpha()).hex();
        this.update();
        this.txtField.m_94144_(HexFormat.of().toHexDigits(this.color));
    }

    private void update() {
        this.setting.update(this.effect, this.renderLocation, this.render, this.color);
    }

    private int setLocationButton() {
        if (this.effect == null || !this.effect.guiElements().contains((Object)GuiElement.LOCATION)) {
            return 0;
        }
        ArrayList<RenderLocation> allowed = new ArrayList<RenderLocation>();
        for (RenderLocation l : RenderLocation.values()) {
            if (this.effect != null && !this.effect.locationAllowed(l)) continue;
            allowed.add(l);
        }
        if (allowed.isEmpty()) {
            return 0;
        }
        Function<RenderLocation, Component> f = loc -> new TranslatableComponent("tenshilib.patreon.location." + loc.toString());
        this.locationButton = CycleButton.m_168894_(f).m_168950_(allowed).m_168948_((Object)this.renderLocation).m_168936_(this.f_96543_ / 2 - 125, this.f_96544_ / 8 + 48, 250, 20, (Component)new TranslatableComponent("tenshilib.patreon.location"), (cycleButton, loc) -> {
            this.renderLocation = loc;
            this.update();
        });
        this.m_142416_((GuiEventListener)this.locationButton);
        return 24;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)12, (int)0xFFFFFF);
        if (this.tier == 0) {
            GuiComponent.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("tenshilib.patreon.not").m_130940_(ChatFormatting.DARK_RED), (int)(this.f_96543_ / 2), (int)46, (int)0xFFFFFF);
        }
        if (this.tier > 0) {
            int ex = this.f_96543_ / 2 - 180;
            int ey = this.f_96544_ / 8 + 168;
            InventoryScreen.m_98850_((int)ex, (int)ey, (int)65, (float)(ex - mouseX), (float)(ey - 83 - mouseY), (LivingEntity)this.f_96541_.f_91074_);
            if (this.effect != null && this.effect.guiElements().contains((Object)GuiElement.COLOR)) {
                GuiComponent.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TranslatableComponent("tenshilib.patreon.color"), (int)(this.f_96543_ / 2 - 55), (int)(this.f_96544_ / 8 + 144 + 8), (int)0xFFFFFF);
            }
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7861_() {
        super.m_7861_();
        if (Minecraft.m_91087_().m_91403_() != null && Minecraft.m_91087_().m_91403_().m_6198_() != null) {
            NetworkCrossPlat.INSTANCE.sendToServer(new C2SRequestUpdateClientPkt());
        }
    }
}

