/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.client.model.CatModel;
import io.github.flemmli97.tenshilib.patreon.client.model.ChomusukeModel;
import io.github.flemmli97.tenshilib.patreon.client.model.HaloModel;
import io.github.flemmli97.tenshilib.patreon.client.model.MeguHatModel;
import io.github.flemmli97.tenshilib.patreon.client.model.PatreonModelData;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffectConfig;
import io.github.flemmli97.tenshilib.patreon.effects.PatreonEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PatreonModelProvider {
    private static final Map<PatreonEffectConfig, EffectRenderer<?>> DATA = new HashMap();
    private static final EffectRenderer<MeguHatModel> MEGUMIN = PatreonModelProvider.register(PatreonEffects.MEGU_HAT, new EffectRenderer<MeguHatModel>(MeguHatModel::new));
    private static final EffectRenderer<ChomusukeModel> CHOMUSUKE = PatreonModelProvider.register(PatreonEffects.CHOMUSUKE, new EffectRenderer<ChomusukeModel>(ChomusukeModel::new));
    private static final EffectRenderer<CatModel> CAT = PatreonModelProvider.register(PatreonEffects.CAT, new EffectRenderer<CatModel>(CatModel::new));
    private static final EffectRenderer<HaloModel> HALO = PatreonModelProvider.register(PatreonEffects.HALO, new EffectRenderer<HaloModel>(HaloModel::new){

        @Override
        public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, Player entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, int red, int green, int blue, int alpha, RenderLocation location) {
            HaloModel model = (HaloModel)this.get();
            model.setRenderLocation(location);
            model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            int i = LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f);
            model.m_7695_(stack, buffer.m_6299_(alpha != 255 ? RenderType.m_110473_((ResourceLocation)model.texture(entity)) : model.m_103119_(model.texture(entity))), packedLight, i, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
            stack.m_85841_(1.15f, 1.15f, 1.15f);
            stack.m_85837_(0.0, -0.175, 0.0);
            model.m_7695_(stack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)model.texture(entity))), packedLight, i, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha * 0.15f / 255.0f);
        }
    });

    public static EffectRenderer<?> get(PatreonEffectConfig conf) {
        return DATA.get(conf);
    }

    public static void registerModelLayers(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> cons) {
        cons.accept(MeguHatModel.LAYER_LOCATION, MeguHatModel::createBodyLayer);
        cons.accept(ChomusukeModel.LAYER_LOCATION, ChomusukeModel::createBodyLayer);
        cons.accept(CatModel.LAYER_LOCATION, CatModel::createBodyLayer);
        cons.accept(HaloModel.LAYER_LOCATION, HaloModel::createBodyLayer);
    }

    private static <T extends EntityModel<Player>, M extends EffectRenderer<T>> M register(PatreonEffectConfig conf, M val) {
        DATA.put(conf, val);
        return val;
    }

    public static class EffectRenderer<T extends EntityModel<Player>> {
        private final Supplier<T> factory;
        private T val;

        EffectRenderer(Supplier<T> factory) {
            this.factory = factory;
        }

        public T get() {
            if (this.val == null) {
                this.val = (EntityModel)this.factory.get();
            }
            return this.val;
        }

        public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, Player entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, int red, int green, int blue, int alpha, RenderLocation location) {
            T model = this.get();
            ((PatreonModelData)model).setRenderLocation(location);
            model.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            int i = LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f);
            model.m_7695_(stack, buffer.m_6299_(alpha != 255 ? RenderType.m_110473_((ResourceLocation)((PatreonModelData)model).texture(entity)) : model.m_103119_(((PatreonModelData)model).texture(entity))), packedLight, i, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
        }
    }
}

