/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.gui.widget;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_768;

public class SuggestionEditBox
extends class_342 {
    public static final Comparator<class_2960> ID_SORT = (r1, r2) -> {
        if (r1.method_12836().equals("minecraft")) {
            if (r2.method_12836().equals("minecraft")) {
                return r1.method_12832().compareTo(r2.method_12832());
            }
            return -1;
        }
        return r1.toString().compareTo(r2.toString());
    };
    private final class_327 font;
    private final int limit;
    private final int lineHeight;
    private final Collection<SuggestionContent> allSuggestions;
    private final boolean top;
    private int offset;
    private int current;
    private String[] suggestions;
    private class_768 rect;
    private boolean hidden;
    private boolean init;
    private int paddingX = 4;
    private int paddingY = 2;

    public SuggestionEditBox(class_327 font, int x, int y, int width, int height, class_2561 message, int maxLimit, boolean top, Collection<SuggestionContent> suggestions) {
        super(font, x, y, width, height, message);
        this.font = font;
        this.allSuggestions = suggestions;
        this.limit = maxLimit;
        Objects.requireNonNull(this.font);
        this.lineHeight = 9 + 3;
        this.top = top;
        this.recalculateSuggestions("");
        this.select(0);
        this.method_1863(null);
    }

    public static Collection<SuggestionContent> ofString(Collection<String> strings) {
        return strings.stream().map(s -> new SuggestionContent((String)s){
            final /* synthetic */ String val$s;
            {
                this.val$s = string;
            }

            @Override
            public boolean matches(String input) {
                return this.val$s.startsWith(input);
            }

            @Override
            public String asString() {
                return this.val$s;
            }
        }).toList();
    }

    public static Collection<SuggestionContent> ofResourceLocation(Collection<class_2960> strings) {
        return strings.stream().sorted().map(res -> new SuggestionContent((class_2960)res){
            final /* synthetic */ class_2960 val$res;
            {
                this.val$res = class_29602;
            }

            @Override
            public boolean matches(String input) {
                return this.val$res.method_12832().startsWith(input) || this.val$res.toString().startsWith(input);
            }

            @Override
            public String asString() {
                return this.val$res.toString();
            }
        }).toList();
    }

    public SuggestionEditBox withPadding(int paddingX, int paddingY) {
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        return this;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        if (this.suggestionsHidden() || this.suggestions.length == 0) {
            return;
        }
        if (this.suggestions.length == 1 && this.method_1882().equals(this.suggestions[0])) {
            return;
        }
        int idx = this.indexFromMouse(mouseY);
        if (idx >= 0 && idx < this.suggestions.length) {
            this.select(idx);
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 1.0f);
        guiGraphics.method_25294(this.rect.method_3321(), this.rect.method_3322(), this.rect.method_3321() + this.rect.method_3319(), this.rect.method_3322() + this.rect.method_3320(), -535818224);
        int x = this.method_46426() + this.paddingX;
        int y = this.rect.method_3322() + this.paddingY;
        for (int i = 0; i < this.suggestions.length; ++i) {
            int idxx = (this.offset + i) % this.suggestions.length;
            if (i >= 5 || idxx >= this.suggestions.length) break;
            String string = this.suggestions[idxx];
            guiGraphics.method_25303(this.font, string, x, y + i * this.lineHeight, this.current == idxx ? 0xFFFF55 : 0xFFFFFF);
        }
        guiGraphics.method_51448().method_22909();
    }

    private boolean suggestionsHidden() {
        return this.hidden || !this.method_20315();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean suggestion;
        boolean bl = suggestion = !this.suggestionsHidden() && this.rect.method_3318((int)mouseX, (int)mouseY);
        if (!suggestion && super.method_25402(mouseX, mouseY, button)) {
            this.hidden = false;
            return true;
        }
        if (!suggestion) {
            return false;
        }
        int i = this.indexFromMouse(mouseY);
        if (i >= 0 && i < this.suggestions.length) {
            this.select(i);
            this.useSuggestion();
        }
        return true;
    }

    private int indexFromMouse(double mouseY) {
        return (int)((mouseY - (double)(this.rect.method_3322() - this.paddingY)) / (double)this.lineHeight + (double)this.offset);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        super.method_25401(mouseX, mouseY, scrollX, scrollY);
        if (this.rect.method_3318((int)mouseX, (int)mouseY)) {
            this.offset = class_3532.method_15340((int)((int)((double)this.offset - scrollY)), (int)0, (int)Math.max(this.suggestions.length - this.limit, 0));
            return true;
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (!this.suggestionsHidden() && this.rect.method_3318((int)mouseX, (int)mouseY)) {
            return true;
        }
        return super.method_25405(mouseX, mouseY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.method_20315()) {
            if (keyCode == 265) {
                this.cycle(-1);
                return true;
            }
            if (keyCode == 264) {
                this.cycle(1);
                return true;
            }
            if (keyCode == 257) {
                this.useSuggestion();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_1863(Consumer<String> responder) {
        super.method_1863(this.of(responder));
    }

    private Consumer<String> of(Consumer<String> other) {
        Consumer<String> updater = s -> {
            String val = this.method_1882();
            this.recalculateSuggestions(val);
        };
        if (other == null || !this.init) {
            this.init = true;
            return updater;
        }
        return s -> {
            other.accept((String)s);
            updater.accept((String)s);
        };
    }

    private void recalculateSuggestions(String input) {
        this.suggestions = (String[])this.allSuggestions.stream().filter(ctx -> ctx.matches(input)).map(SuggestionContent::asString).toArray(String[]::new);
        int sizeY = Math.min(this.suggestions.length, this.limit) * this.lineHeight;
        int y = this.method_46427() + (this.top ? -sizeY - this.paddingY : this.method_25364() + this.paddingY);
        int width = this.field_22758;
        for (String sugg : this.suggestions) {
            int newWidth = this.font.method_1727(sugg) + this.paddingX * 2;
            if (newWidth <= width) continue;
            width = newWidth;
        }
        this.rect = new class_768(this.method_46426(), y, width, sizeY + this.paddingY);
        this.hidden = false;
    }

    public void cycle(int change) {
        this.select(this.current + change);
        int i = this.offset;
        int j = this.offset + this.limit - 1;
        if (this.current < i) {
            this.offset = class_3532.method_15340((int)this.current, (int)0, (int)Math.max(this.suggestions.length - this.limit, 0));
        } else if (this.current > j) {
            this.offset = class_3532.method_15340((int)(this.current - this.limit), (int)0, (int)Math.max(this.suggestions.length - this.limit, 0));
        }
    }

    public void select(int index) {
        this.current = index;
        if (this.current < 0) {
            this.current += this.suggestions.length;
        }
        if (this.current >= this.suggestions.length) {
            this.current -= this.suggestions.length;
        }
    }

    public void useSuggestion() {
        String suggestion = this.suggestions[this.current];
        this.method_1852(suggestion);
        this.method_1875(suggestion.length());
        this.method_1884(suggestion.length());
        this.select(this.current);
        this.hidden = true;
    }

    public static interface SuggestionContent {
        public boolean matches(String var1);

        public String asString();
    }
}

