/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.client.model.animation;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import io.github.flemmli97.tenshilib.client.model.animation.AnimationBone;
import io.github.flemmli97.tenshilib.client.model.animation.keyframe.ParticleKeyFrame;
import io.github.flemmli97.tenshilib.client.model.animation.keyframe.SoundKeyFrame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3518;

public record Animation(double length, boolean loop, Map<String, AnimationBone> bones, List<ParticleKeyFrame> particleFrames, List<SoundKeyFrame> soundFrames, Map<String, double[]> markerFrames) {
    public static List<ParticleKeyFrame> parseParticles(JsonObject obj) {
        ArrayList frames = new ArrayList();
        obj.asMap().forEach((time, val) -> {
            JsonObject data = val.getAsJsonObject();
            frames.add(new ParticleKeyFrame(Double.parseDouble(time) * 20.0, class_3518.method_15253((JsonObject)data, (String)"effect", (String)""), class_3518.method_15253((JsonObject)data, (String)"locator", (String)"")));
        });
        frames.sort(null);
        return List.copyOf(frames);
    }

    public static List<SoundKeyFrame> parseSound(JsonObject obj) {
        ArrayList frames = new ArrayList();
        obj.asMap().forEach((time, val) -> {
            JsonObject data = val.getAsJsonObject();
            frames.add(new SoundKeyFrame(Double.parseDouble(time) * 20.0, class_3518.method_15253((JsonObject)data, (String)"effect", (String)"")));
        });
        frames.sort(null);
        return List.copyOf(frames);
    }

    public static Map<String, double[]> parseMarkers(JsonObject obj) {
        HashMap<String, List> frames = new HashMap<String, List>();
        obj.asMap().forEach((time, val) -> {
            String name = val.getAsString();
            if (name.endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            frames.computeIfAbsent(name, ok -> new ArrayList()).add(Double.parseDouble(time) * 20.0);
        });
        ImmutableMap.Builder map = ImmutableMap.builder();
        frames.forEach((name, vals) -> {
            vals.sort(null);
            map.put(name, (Object)vals.stream().mapToDouble(d -> d).toArray());
        });
        return map.build();
    }
}

