/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.loader.TenshiLibCrossPlat;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;

public abstract class DamageCloudEntity
extends class_1297
implements class_8046 {
    protected static final class_2940<Optional<UUID>> SHOOTER_UUID = class_2945.method_12791(DamageCloudEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Float> RADIUS = class_2945.method_12791(DamageCloudEntity.class, (class_2941)class_2943.field_13320);
    private class_1297 shooter;
    protected int livingTicks;
    private int attackedEntities = 0;

    public DamageCloudEntity(class_1299<? extends DamageCloudEntity> type, class_1937 level) {
        super(type, level);
    }

    public DamageCloudEntity(class_1299<? extends DamageCloudEntity> type, class_1937 level, double x, double y, double z) {
        this(type, level);
        this.method_5814(x, y, z);
    }

    public DamageCloudEntity(class_1299<? extends DamageCloudEntity> type, class_1937 level, class_1309 shooter) {
        this(type, level, shooter.method_23317(), shooter.method_23318(), shooter.method_23321());
        this.shooter = shooter;
        this.field_6011.method_12778(SHOOTER_UUID, Optional.of(shooter.method_5667()));
        this.method_5710(shooter.method_36454(), shooter.method_36455());
    }

    public int maxHitCount() {
        return -1;
    }

    public float radiusIncrease() {
        return 0.0f;
    }

    public double maxRadius() {
        return -1.0;
    }

    public int livingTicks() {
        return this.livingTicks;
    }

    public int livingTickMax() {
        return 200;
    }

    public boolean canHitShooter() {
        return false;
    }

    public boolean canStartDamage() {
        return (this.livingTicks - 1) % 5 == 0;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(SHOOTER_UUID, Optional.empty());
        builder.method_56912(RADIUS, (Object)Float.valueOf(0.0f));
    }

    public float getRadius() {
        return ((Float)this.field_6011.method_12789(RADIUS)).floatValue();
    }

    public void setRadius(float val) {
        this.field_6011.method_12778(RADIUS, (Object)Float.valueOf(val));
    }

    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void method_5773() {
        super.method_5773();
        ++this.livingTicks;
        if (!this.method_37908().field_9236) {
            if (this.livingTicks > this.livingTickMax()) {
                this.method_5650(class_1297.class_5529.field_26998);
                return;
            }
            float radius = this.getRadius();
            if ((double)radius < this.maxRadius()) {
                this.setRadius(radius + this.radiusIncrease());
            }
            if (this.canStartDamage() && this.method_5805()) {
                List targets = this.method_37908().method_8390(class_1309.class, this.damageBoundingBox(), this::canHit);
                for (class_1309 living : targets) {
                    if ((this.maxHitCount() == -1 || this.attackedEntities < this.maxHitCount()) && this.damageEntity(living)) {
                        ++this.attackedEntities;
                    }
                    if (this.maxHitCount() == -1 || this.attackedEntities < this.maxHitCount()) continue;
                    this.onMaxEntities();
                    break;
                }
            }
        }
    }

    protected boolean canHit(class_1309 target) {
        if (target.method_7325() || !target.method_5805() || !target.method_5863()) {
            return false;
        }
        class_1297 entity = this.method_24921();
        if (entity == null) {
            return true;
        }
        if (TenshiLibCrossPlat.INSTANCE.isSameMultipart((class_1297)target, this.method_24921())) {
            return false;
        }
        return !target.equals((Object)this.method_24921()) || !entity.method_5794((class_1297)target) || this.canHitShooter() && this.field_6012 >= 3;
    }

    protected abstract boolean damageEntity(class_1309 var1);

    protected void onMaxEntities() {
        this.method_5650(class_1297.class_5529.field_26998);
    }

    protected class_238 damageBoundingBox() {
        float radius = this.getRadius();
        return this.method_5829().method_1009((double)radius, 0.3, (double)radius);
    }

    protected void method_5749(class_2487 compound) {
        if (compound.method_25928("Shooter")) {
            this.field_6011.method_12778(SHOOTER_UUID, Optional.of(compound.method_25926("Shooter")));
        }
        this.shooter = this.method_24921();
        this.livingTicks = compound.method_10550("LivingTicks");
        this.attackedEntities = compound.method_10550("AttackedEntities");
        this.field_6011.method_12778(RADIUS, (Object)Float.valueOf(compound.method_10583("Radius")));
    }

    protected void method_5652(class_2487 compound) {
        ((Optional)this.field_6011.method_12789(SHOOTER_UUID)).ifPresent(uuid -> compound.method_25927("Shooter", uuid));
        compound.method_10569("LivingTicks", this.livingTicks);
        compound.method_10569("AttackedEntities", this.attackedEntities);
        compound.method_10548("Radius", this.getRadius());
    }

    @Nullable
    public class_1297 method_24921() {
        if (this.shooter != null && !this.shooter.method_31481()) {
            return this.shooter;
        }
        ((Optional)this.field_6011.method_12789(SHOOTER_UUID)).ifPresent(uuid -> {
            this.shooter = EntityUtils.findFromUUID(class_1297.class, this.method_37908(), uuid);
        });
        return this.shooter;
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.field_6011.method_12789(SHOOTER_UUID)).orElse(null);
    }
}

