/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.tenshilib.TenshiLib;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class SpawnEgg
extends class_1826 {
    private static final Map<Supplier<? extends class_1299<?>>, SpawnEgg> EGGS_SUP = Maps.newIdentityHashMap();
    private static final Map<class_1299<?>, SpawnEgg> EGGS = Maps.newIdentityHashMap();
    private static final Map<class_1299<? extends class_1308>, class_1826> BY_ID = SpawnEgg.fetchMapFromSpawnEgg();
    private static boolean resolved;
    private static final MapCodec<class_1299<?>> ENTITY_TYPE_FIELD_CODEC;
    protected static final class_2357 DEF;
    private final Supplier<? extends class_1299<?>> type;
    private final boolean mob;

    public SpawnEgg(Supplier<? extends class_1299<?>> type, int primary, int secondary, class_1792.class_1793 props) {
        super(null, primary, secondary, props);
        BY_ID.remove(null);
        this.type = type;
        this.mob = false;
        this.onInit(type);
    }

    public SpawnEgg(EntityTypeHolder<?> type, int primary, int secondary, class_1792.class_1793 props) {
        super(null, primary, secondary, props);
        BY_ID.remove(null);
        this.type = type.type;
        this.mob = class_1308.class.isAssignableFrom(type.clss);
        this.onInit(type.type);
    }

    private static Map<class_1299<? extends class_1308>, class_1826> fetchMapFromSpawnEgg() {
        for (Field f : class_1826.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Map.class.isAssignableFrom(f.getType())) continue;
            try {
                f.setAccessible(true);
                Object obj = f.get(null);
                if (!(obj instanceof IdentityHashMap)) continue;
                return (Map)f.get(null);
            }
            catch (IllegalAccessException e) {
                TenshiLib.LOGGER.error((Object)e);
            }
        }
        throw new RuntimeException("Couldn't find spawnegg map");
    }

    public static void resolveEggs() {
        if (resolved) {
            return;
        }
        resolved = true;
        EGGS_SUP.forEach((type, egg) -> {
            if (egg.addToDefaultSpawneggs() && egg.mob) {
                BY_ID.put((class_1299<? extends class_1308>)((class_1299)type.get()), (class_1826)egg);
            }
            EGGS.put((class_1299<?>)((class_1299)type.get()), (SpawnEgg)((Object)egg));
        });
    }

    public static Iterable<SpawnEgg> getEggs() {
        return Iterables.unmodifiableIterable(EGGS_SUP.values());
    }

    public static Optional<SpawnEgg> fromType(class_1299<?> type) {
        SpawnEgg.resolveEggs();
        return Optional.ofNullable(EGGS.get(type));
    }

    public static Optional<SpawnEgg> fromID(class_2960 id) {
        return class_7923.field_41177.method_17966(id).flatMap(SpawnEgg::fromType);
    }

    protected void onInit(Supplier<? extends class_1299<?>> type) {
        EGGS_SUP.put(type, this);
    }

    public boolean onEntitySpawned(class_1297 e, class_1799 stack, @Nullable class_1657 player) {
        return true;
    }

    public class_2561 getEntityName(class_1799 stack) {
        return stack.method_57826(class_9334.field_49631) ? stack.method_7964() : null;
    }

    public class_2357 dispenser() {
        return DEF;
    }

    public boolean addToDefaultSpawneggs() {
        return true;
    }

    public class_2561 method_7864(class_1799 stack) {
        return class_2561.method_43469((String)this.method_7866(stack), (Object[])new Object[]{class_2561.method_43471((String)this.method_8015(stack).method_5882())});
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_2586 blockEntity;
        class_1937 level = ctx.method_8045();
        if (!(level instanceof class_3218)) {
            return class_1269.field_5812;
        }
        class_1799 stack = ctx.method_8041();
        class_2338 blockpos = ctx.method_8037();
        class_2350 direction = ctx.method_8038();
        class_2680 blockstate = level.method_8320(blockpos);
        class_1269 onBlock = this.onBlockUse(stack, blockpos, blockstate, blockEntity = level.method_8321(blockpos));
        if (onBlock != class_1269.field_5811) {
            return onBlock;
        }
        if (blockEntity instanceof class_2636) {
            class_2636 spawner = (class_2636)blockEntity;
            class_2487 nbt = new class_2487();
            spawner.method_11390().method_8272(nbt);
            nbt.method_10551("SpawnPotentials");
            nbt.method_10551("SpawnData");
            class_1952.field_34460.encodeStart((DynamicOps)class_2509.field_11560, (Object)new class_1952(((class_9279)stack.method_57824(class_9334.field_49609)).method_57461(), Optional.empty(), Optional.empty())).resultOrPartial(string -> TenshiLib.LOGGER.warn("Invalid SpawnData: {}", string)).ifPresent(t -> nbt.method_10566("SpawnData", t));
            spawner.method_11390().method_8280(blockEntity.method_10997(), blockEntity.method_11016(), nbt);
            spawner.method_5431();
            ctx.method_8045().method_8413(ctx.method_8037(), blockstate, blockstate, 3);
            return class_1269.field_5812;
        }
        class_2338 blockPos = blockstate.method_26220((class_1922)level, blockpos).method_1110() ? blockpos : blockpos.method_10093(direction);
        class_1297 entity = SpawnEgg.spawnEntity((class_3218)level, ctx.method_8036(), stack, blockPos, class_3730.field_16465, true, !Objects.equals(blockpos, blockPos) && direction == class_2350.field_11036);
        if (entity != null) {
            stack.method_7934(1);
            if (ctx.method_8036() != null) {
                ctx.method_8036().method_7259(class_3468.field_15372.method_14956((Object)this));
            }
            level.method_43275((class_1297)ctx.method_8036(), (class_6880)class_5712.field_28738, entity.method_19538());
        }
        return class_1269.field_21466;
    }

    public class_1269 onBlockUse(class_1799 stack, class_2338 pos, class_2680 state, @Nullable class_2586 tile) {
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_3965 hitResult = SpawnEgg.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return class_1271.method_22430((Object)stack);
        }
        if (!(level instanceof class_3218)) {
            return class_1271.method_22427((Object)stack);
        }
        class_3218 serverLevel = (class_3218)level;
        class_2338 blockpos = hitResult.method_17777();
        if (!(level.method_8320(blockpos).method_26204() instanceof class_2404)) {
            return class_1271.method_22430((Object)stack);
        }
        if (level.method_8505(player, blockpos) && player.method_7343(blockpos, hitResult.method_17780(), stack)) {
            class_1297 entity = SpawnEgg.spawnEntity(serverLevel, player, stack, blockpos, class_3730.field_16465, true, false);
            if (entity != null) {
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
                level.method_43275((class_1297)player, (class_6880)class_5712.field_28738, entity.method_19538());
                return class_1271.method_22428((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    public class_1299<?> method_8015(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_57825(class_9334.field_49609, (Object)class_9279.field_49302);
        return !customData.method_57458() ? customData.method_57446(ENTITY_TYPE_FIELD_CODEC).result().orElse(this.type.get()) : this.type.get();
    }

    public class_7699 method_45322() {
        return this.type.get().method_45322();
    }

    public static class_1297 spawnEntity(class_3218 level, class_1657 player, class_1799 stack, class_2338 pos, class_3730 reason, boolean updateLocation, boolean doCollisionOffset) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof SpawnEgg)) {
            return null;
        }
        SpawnEgg item = (SpawnEgg)class_17922;
        class_1299<?> type = item.method_8015(stack);
        class_1297 entity = type.method_5888(level, class_1299.method_48009((class_3218)level, (class_1799)stack, (class_1657)player), pos, reason, updateLocation, doCollisionOffset);
        if (entity != null) {
            if (!item.onEntitySpawned(entity, stack, player)) {
                return null;
            }
            level.method_30771(entity);
        }
        return entity;
    }

    public int getColor(class_1799 stack, int tintIndex) {
        return this.method_8016(tintIndex);
    }

    static {
        ENTITY_TYPE_FIELD_CODEC = class_7923.field_41177.method_39673().fieldOf("id");
        DEF = (blockSource, stack) -> {
            class_2350 direction = (class_2350)blockSource.comp_1969().method_11654((class_2769)class_2315.field_10918);
            SpawnEgg.spawnEntity(blockSource.comp_1967(), null, stack, blockSource.comp_1968().method_10093(direction), class_3730.field_16470, direction != class_2350.field_11036, false);
            stack.method_7934(1);
            blockSource.comp_1967().method_43276((class_6880)class_5712.field_28738, blockSource.comp_1968(), class_5712.class_7397.method_43287((class_2680)blockSource.comp_1969()));
            return stack;
        };
    }

    public record EntityTypeHolder<T extends class_1297>(Class<T> clss, Supplier<? extends class_1299<? extends T>> type) {
    }
}

