/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils.math;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MathUtils {
    public static final class_243 NORMAL_X = new class_243(1.0, 0.0, 0.0);
    public static final class_243 NORMAL_Y = new class_243(0.0, 1.0, 0.0);
    public static final class_243 NORMAL_Z = new class_243(0.0, 0.0, 1.0);

    public static double[] closestOnCircle(double centerX, double centerY, double pointX, double pointY, double radius) {
        double x = pointX - centerX;
        double y = pointY - centerY;
        double d0 = Math.sqrt(x * x + y * y);
        return new double[]{x / d0 * radius + centerX, y / d0 * radius + centerY};
    }

    public static List<float[]> pointsOfCircle(float radius, int density) {
        float rad = (float)density * ((float)Math.PI / 180);
        float i = -rad;
        ArrayList<float[]> list = new ArrayList<float[]>();
        while ((double)i < Math.PI * 2) {
            list.add(new float[]{radius * class_3532.method_15362((float)(i += rad)), radius * class_3532.method_15374((float)i)});
        }
        return list;
    }

    public static List<Vector3f> rotatedVecs(Vector3f dir, Vector3f axis, float minDeg, float maxDeg, float step) {
        float y;
        ArrayList<Vector3f> list = new ArrayList<Vector3f>();
        list.add(new Vector3f((Vector3fc)dir));
        for (y = step; y <= maxDeg; y += step) {
            list.add(dir.rotateAxis(y * ((float)Math.PI / 180), axis.x(), axis.y(), axis.z(), new Vector3f()));
        }
        for (y = minDeg; y <= -step; y += step) {
            list.add(dir.rotateAxis(y * ((float)Math.PI / 180), axis.x(), axis.y(), axis.z(), new Vector3f()));
        }
        return list;
    }

    public static List<Vector3d> rotatedVecs(Vector3d dir, Vector3d axis, float minDeg, float maxDeg, float step) {
        float y;
        ArrayList<Vector3d> list = new ArrayList<Vector3d>();
        list.add(new Vector3d((Vector3dc)dir));
        for (y = step; y <= maxDeg; y += step) {
            list.add(dir.rotateAxis((double)(y * ((float)Math.PI / 180)), axis.x(), axis.y(), axis.z(), new Vector3d()));
        }
        for (y = minDeg; y <= -step; y += step) {
            list.add(dir.rotateAxis((double)(y * ((float)Math.PI / 180)), axis.x(), axis.y(), axis.z(), new Vector3d()));
        }
        return list;
    }

    public static class_243 closestPointToLine(class_243 point, class_243 from, class_243 dir) {
        if (dir.equals((Object)class_243.field_1353)) {
            return from;
        }
        double lengthSq = dir.method_1027();
        double x = Math.max(0.0, Math.min(1.0, point.method_1020(from).method_1026(dir) / lengthSq));
        return from.method_1019(dir.method_1021(x));
    }

    public static double[] rotate2d(double x, double y, double angle) {
        return new double[]{x * Math.cos(angle) - y * Math.sin(angle), y * Math.cos(angle) + x * Math.sin(angle)};
    }

    public static double[][] createRegularPolygonPoints(int shape, float width) {
        if (shape <= 2) {
            throw new IllegalArgumentException("Can't create a polygon with 2 or less corners!");
        }
        double[][] res = new double[shape][];
        Vector3d base = new Vector3d((double)width, 0.0, 0.0);
        float rotatePer = 360.0f / (float)shape;
        if (shape % 2 == 0) {
            base = base.rotateAxis((double)(rotatePer * 0.5f * ((float)Math.PI / 180)), 0.0, 0.0, 1.0);
        }
        res[0] = new double[]{base.x, base.y};
        for (int i = 1; i < shape; ++i) {
            Vector3d rotated = base.rotateAxis((double)(rotatePer * (float)i * ((float)Math.PI / 180)), 0.0, 0.0, 1.0, new Vector3d());
            res[i] = new double[]{rotated.x, rotated.y};
        }
        return res;
    }

    public static float[][] createRegularPolygonPointsF(int shape, float width) {
        if (shape <= 2) {
            throw new IllegalArgumentException("Can't create a polygon with 2 or less corners!");
        }
        float[][] res = new float[shape][];
        Vector3f base = new Vector3f(width, 0.0f, 0.0f);
        float rotatePer = 360.0f / (float)shape;
        if (shape % 2 == 0) {
            base = base.rotateAxis(rotatePer * 0.5f * ((float)Math.PI / 180), 0.0f, 0.0f, 1.0f);
        }
        res[0] = new float[]{base.x, base.y};
        for (int i = 1; i < shape; ++i) {
            Vector3f rotated = base.rotateAxis(rotatePer * (float)i * ((float)Math.PI / 180), 0.0f, 0.0f, 1.0f, new Vector3f());
            res[i] = new float[]{rotated.x, rotated.y};
        }
        return res;
    }

    public static Pair<class_243, class_243> closestPointsAABB(class_238 axisalignedbb, class_238 axisalignedbb2) {
        class_243 first = new class_243(axisalignedbb.field_1323 <= axisalignedbb2.field_1323 ? axisalignedbb2.field_1323 : (axisalignedbb.field_1320 >= axisalignedbb2.field_1320 ? axisalignedbb2.field_1320 : axisalignedbb.field_1323), axisalignedbb.field_1322 <= axisalignedbb2.field_1322 ? axisalignedbb2.field_1322 : (axisalignedbb.field_1325 >= axisalignedbb2.field_1325 ? axisalignedbb2.field_1325 : axisalignedbb.field_1322), axisalignedbb.field_1321 <= axisalignedbb2.field_1321 ? axisalignedbb2.field_1321 : (axisalignedbb.field_1324 >= axisalignedbb2.field_1324 ? axisalignedbb2.field_1324 : axisalignedbb.field_1321));
        class_243 second = new class_243(axisalignedbb2.field_1323 <= axisalignedbb.field_1323 ? axisalignedbb.field_1323 : (axisalignedbb2.field_1320 >= axisalignedbb.field_1320 ? axisalignedbb.field_1320 : axisalignedbb2.field_1323), axisalignedbb2.field_1322 <= axisalignedbb.field_1322 ? axisalignedbb.field_1322 : (axisalignedbb2.field_1325 >= axisalignedbb.field_1325 ? axisalignedbb.field_1325 : axisalignedbb2.field_1322), axisalignedbb2.field_1321 <= axisalignedbb.field_1321 ? axisalignedbb.field_1321 : (axisalignedbb2.field_1324 >= axisalignedbb.field_1324 ? axisalignedbb.field_1324 : axisalignedbb2.field_1321));
        return Pair.of((Object)first, (Object)second);
    }

    public static double distTo(class_1297 e, class_243 from, class_243 to) {
        double d = Double.MAX_VALUE;
        class_243 dir = to.method_1020(from);
        for (double height = 0.0; height <= (double)e.method_17682(); height += (double)e.method_17682() * 0.1) {
            class_243 point = e.method_19538().method_1031(0.0, height, 0.0);
            double nD = MathUtils.closestPointToLine(point, from, dir).method_1025(point);
            if (!(nD < d)) continue;
            d = nD;
        }
        return d;
    }

    public static class_243 farestPointToLine(class_243 point, class_243 l1, class_243 dir) {
        return new class_243(Math.abs(l1.field_1352 - point.field_1352) > Math.abs(dir.field_1352 - point.field_1352) ? l1.field_1352 : dir.field_1352, Math.abs(l1.field_1351 - point.field_1351) > Math.abs(dir.field_1351 - point.field_1351) ? l1.field_1351 : dir.field_1351, Math.abs(l1.field_1350 - point.field_1350) > Math.abs(dir.field_1350 - point.field_1350) ? l1.field_1350 : dir.field_1350);
    }

    public static double roundTo(double val, double step) {
        return (double)Math.round(val / (double)((float)step)) * step;
    }
}

