/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.fabric.loader.registry;

import io.github.flemmli97.tenshilib.fabric.loader.registry.DeferredRegistrationHandler;
import io.github.flemmli97.tenshilib.fabric.loader.registry.VanillaEntrySupplier;
import io.github.flemmli97.tenshilib.loader.registry.LoaderRegister;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class VanillaRegisterHandler<T>
implements LoaderRegister<T> {
    private final class_5321<? extends class_2378<T>> key;
    private final String modid;
    private final Map<VanillaEntrySupplier<T, ? extends T>, Supplier<? extends T>> entries = new LinkedHashMap<VanillaEntrySupplier<T, ? extends T>, Supplier<? extends T>>();
    private final Set<VanillaEntrySupplier<T, ? extends T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());

    public VanillaRegisterHandler(class_5321<? extends class_2378<T>> key, String modid) {
        this.key = key;
        this.modid = modid;
    }

    @Override
    public <I extends T> RegistryEntrySupplier<T, I> register(String name, Function<class_2960, I> func) {
        class_2960 id = class_2960.method_60655((String)this.modid, (String)name);
        VanillaEntrySupplier v = new VanillaEntrySupplier(class_5321.method_29179(this.key, (class_2960)id));
        this.entries.putIfAbsent(v, () -> func.apply(id));
        return v;
    }

    @Override
    public void registerContent() {
        DeferredRegistrationHandler.add(this.key.method_29177(), this);
    }

    protected class_2378<T> registryFrom() {
        class_2378 reg = (class_2378)class_7923.field_41167.method_10223(this.key.method_29177());
        if (reg == null) {
            throw new NullPointerException("Failed to get a corresponding register for " + String.valueOf(this.key));
        }
        return reg;
    }

    void finalizeRegister() {
        class_2378 registry = this.registryFrom();
        this.entries.forEach((v, s) -> {
            class_2378.method_10230((class_2378)registry, (class_2960)v.getID(), s.get());
            v.bind(registry);
        });
    }

    @Override
    public Collection<? extends RegistryEntrySupplier<T, ? extends T>> getEntries() {
        return this.entriesView;
    }

    public String toString() {
        return String.format("Registration handler for %s for %s", this.key, this.modid);
    }
}

